/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.statistics;

import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChange;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

class IssueInSprintChecker {
    private boolean lastExplicitAdd;
    private String lastStatus;
    private boolean issueIsInSprint;
    private final Collection<String> mappedStatusIds;

    IssueInSprintChecker(Collection<String> mappedStatusIds) {
        this.mappedStatusIds = mappedStatusIds;
        this.lastExplicitAdd = false;
        this.issueIsInSprint = false;
        this.lastStatus = "";
    }

    boolean check(BurndownChange burndownChange) {
        boolean isLastStatusMapped = this.isStatusMapped(this.lastStatus);
        if (burndownChange.added != null && burndownChange.column == null) {
            this.issueIsInSprint = burndownChange.added != false && isLastStatusMapped;
        } else if (burndownChange.added == null && burndownChange.column != null) {
            this.issueIsInSprint = this.isStatusMapped(burndownChange.column.newStatus) && this.lastExplicitAdd;
        } else if (burndownChange.added != null && burndownChange.column != null) {
            this.issueIsInSprint = this.isStatusMapped(burndownChange.column.newStatus) && burndownChange.added != false;
        }
        this.saveRecentStateOfBurndownChange(burndownChange);
        return this.issueIsInSprint;
    }

    private void saveRecentStateOfBurndownChange(BurndownChange burndownChange) {
        if (burndownChange.added != null) {
            this.lastExplicitAdd = burndownChange.added;
        }
        if (burndownChange.column != null && StringUtils.isNotEmpty((CharSequence)burndownChange.column.newStatus)) {
            this.lastStatus = burndownChange.column.newStatus;
        }
    }

    private boolean isStatusMapped(String lastStatus) {
        return lastStatus != null && this.mappedStatusIds.contains(lastStatus);
    }
}

