/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.statistics;

import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.util.DateUtils;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChange;
import com.atlassian.greenhopper.web.rapid.issue.statistics.IssueInSprintChecker;
import com.atlassian.greenhopper.web.rapid.issue.statistics.IssueReopenedChecker;
import com.atlassian.greenhopper.web.rapid.issue.statistics.IssueSprintStatistics;
import com.atlassian.greenhopper.web.rapid.issue.statistics.IssueStatisticValueResolver;
import com.atlassian.jira.issue.Issue;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HistoricalEstimateStatisticValueResolver
implements IssueStatisticValueResolver {
    private static final Logger LOG = LoggerFactory.getLogger(HistoricalEstimateStatisticValueResolver.class);
    private final StatisticsField estimationStatistic;
    private final Sprint sprint;
    private final Collection<String> mappedStatusIds;
    private final Map<String, List<BurndownChange>> changes;

    public HistoricalEstimateStatisticValueResolver(StatisticsField estimationStatistic, Sprint sprint, Map<String, List<BurndownChange>> historyData, Collection<String> mappedStatusIds) {
        this.estimationStatistic = estimationStatistic;
        this.sprint = sprint;
        this.mappedStatusIds = mappedStatusIds;
        this.changes = historyData;
    }

    @Override
    public Double getValue(Issue issue) {
        return this.getValue(issue.getKey());
    }

    @Nullable
    public Double getValue(String issueKey) {
        BurndownChange burndownChange;
        boolean hasSprintStarted;
        List<BurndownChange> burndownChanges = this.changes.get(issueKey);
        if (burndownChanges == null) {
            return null;
        }
        Double lastValue = null;
        boolean isInSprint = false;
        IssueInSprintChecker issueInSprintChecker = new IssueInSprintChecker(this.mappedStatusIds);
        Iterator<BurndownChange> iterator = burndownChanges.iterator();
        while (!(!iterator.hasNext() || (hasSprintStarted = (burndownChange = iterator.next()).getDate().isAfter((ReadableInstant)this.sprint.getStartDate())) && isInSprint)) {
            isInSprint = issueInSprintChecker.check(burndownChange);
            if (burndownChange.statC == null) continue;
            lastValue = burndownChange.statC.newValue;
        }
        return lastValue;
    }

    @Nullable
    public Double getCurrentEstimation(String issueKey) {
        List<BurndownChange> burndownChanges = this.changes.get(issueKey);
        Double lastValue = null;
        for (BurndownChange burndownChange : burndownChanges) {
            if (burndownChange.statC == null) continue;
            lastValue = burndownChange.statC.newValue;
        }
        return lastValue;
    }

    @Override
    public StatisticsField getStatisticsField() {
        return this.estimationStatistic;
    }

    @Override
    public String getText(Double value) {
        return null;
    }

    public boolean wasIssueMarkedAsDoneDuringSprint(String issueKey) {
        boolean issueHasBeenAddedBackToSprint;
        List<BurndownChange> burndownChanges = this.changes.get(issueKey);
        if (burndownChanges == null) {
            return false;
        }
        boolean thereIsNoAddedInformation = burndownChanges.stream().noneMatch(burndownChange -> burndownChange.added != null);
        if (thereIsNoAddedInformation) {
            return false;
        }
        boolean issueIsInSprintNow = false;
        boolean issueDoneInSprintDuration = false;
        boolean issueWasRemovedBeforeSprintComplete = false;
        boolean issueHasBeenReopenedAfterBeingRemoved = false;
        IssueInSprintChecker issueInSprintChecker = new IssueInSprintChecker(this.mappedStatusIds);
        int index = 0;
        for (BurndownChange burndownChange2 : burndownChanges) {
            issueIsInSprintNow = issueInSprintChecker.check(burndownChange2);
            if (burndownChange2.added != null) {
                if (BooleanUtils.isFalse((Boolean)burndownChange2.added)) {
                    issueWasRemovedBeforeSprintComplete = burndownChange2.date.isAfter((ReadableInstant)this.sprint.getStartDate()) && burndownChange2.date.isBefore((ReadableInstant)this.sprint.getCompleteDate());
                }
                issueHasBeenReopenedAfterBeingRemoved = this.hasIssueBeenReopenedAfterBeingRemoved(index, burndownChanges, burndownChange2, issueHasBeenReopenedAfterBeingRemoved);
            }
            if (burndownChange2.column != null) {
                boolean issueMovedToDone = BooleanUtils.isTrue((Boolean)burndownChange2.column.done);
                boolean issueCompletedDateInSprintPeriod = HistoricalEstimateStatisticValueResolver.isIssueCompletedInSprint(burndownChange2, this.sprint);
                issueDoneInSprintDuration = issueMovedToDone && issueCompletedDateInSprintPeriod && issueIsInSprintNow;
            }
            ++index;
        }
        boolean bl = issueHasBeenAddedBackToSprint = issueIsInSprintNow && issueWasRemovedBeforeSprintComplete;
        boolean wasDoneDuringSprint = issueIsInSprintNow ? (issueHasBeenAddedBackToSprint ? !issueHasBeenReopenedAfterBeingRemoved && issueDoneInSprintDuration : issueDoneInSprintDuration) : !issueWasRemovedBeforeSprintComplete && issueDoneInSprintDuration;
        LOG.debug(String.format("___________ %s wasDoneDuringSprint is %b ___________", issueKey, wasDoneDuringSprint));
        return wasDoneDuringSprint;
    }

    private boolean hasIssueBeenReopenedAfterBeingRemoved(int index, List<BurndownChange> burndownChanges, BurndownChange burndownChange, boolean lastStatus) {
        if (BooleanUtils.isFalse((Boolean)burndownChange.added)) {
            return IssueReopenedChecker.checkIssueReopened(burndownChanges).outsideTheSprintUntiAddedBackToSprint().startFrom(index).build().check();
        }
        return lastStatus && BooleanUtils.isFalse((Boolean)IssueReopenedChecker.checkIssueReopened(burndownChanges).insideTheSprintUntilMovedToAnotherSprint().startFrom(index).build().check());
    }

    private static boolean isIssueCompletedInSprint(BurndownChange burndownChange, Sprint sprint) {
        if (Sprint.State.FUTURE == sprint.getState()) {
            return false;
        }
        if (Sprint.State.ACTIVE == sprint.getState()) {
            return burndownChange.getDate().isAfter((ReadableInstant)sprint.getStartDate());
        }
        return DateUtils.isInRange((ReadableInstant)burndownChange.getDate(), (ReadableInstant)sprint.getStartDate(), (ReadableInstant)sprint.getCompleteDate());
    }

    public IssueSprintStatistics getIssueSprintStatistics(String issueKey) {
        List<BurndownChange> burndownChanges = this.changes.get(issueKey);
        if (burndownChanges == null) {
            return null;
        }
        IssueSprintStatistics.Builder builder = new IssueSprintStatistics.Builder();
        IssueInSprintChecker issueInSprintChecker = new IssueInSprintChecker(this.mappedStatusIds);
        for (BurndownChange burndownChange : burndownChanges) {
            boolean isInSprintForBoard = issueInSprintChecker.check(burndownChange);
            if (burndownChange.getDate().isBefore((ReadableInstant)this.sprint.getCompleteDate()) && burndownChange.column != null && burndownChange.column.newStatus != null) {
                builder.setIssueStatusAtEndOfSprint(burndownChange.column.newStatus);
            }
            if (burndownChange.getDate().isBefore((ReadableInstant)this.sprint.getStartDate())) {
                builder.setWasIssueInAtSprintStart(isInSprintForBoard);
            }
            if (burndownChange.getDate().isAfter((ReadableInstant)this.sprint.getStartDate()) && burndownChange.getDate().isBefore((ReadableInstant)this.sprint.getCompleteDate())) {
                if (!builder.wasIssueInAtSprintStart() && isInSprintForBoard) {
                    builder.setWasIssueAddedDuringSprint(true);
                }
                builder.setWasIssueRemovedDuringSprint(!isInSprintForBoard);
            }
            if (!burndownChange.getDate().isBefore((ReadableInstant)this.sprint.getCompleteDate()) || burndownChange.column == null || burndownChange.column.done == null) continue;
            builder.setWasIssueCompleted(burndownChange.column.done);
        }
        builder.setWasIssueCompletedInTheCurrentSprint(this.wasIssueMarkedAsDoneDuringSprint(issueKey));
        return builder.build();
    }
}

