/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.issuelink;

import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.jira.bc.issue.link.RemoteIssueLinkService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="issuelink")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RemoteIssueLinkResource
extends AbstractResource {
    private RemoteIssueLinkService remoteIssueLinkService;

    public RemoteIssueLinkResource(RemoteIssueLinkService remoteIssueLinkService) {
        this.remoteIssueLinkService = remoteIssueLinkService;
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteRemoteIssueLink(final @PathParam(value="id") Long remoteIssueLinkId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = RemoteIssueLinkResource.this.getUser();
                RemoteIssueLinkService.DeleteValidationResult deleteValidationResult = RemoteIssueLinkResource.this.remoteIssueLinkService.validateDelete(user, remoteIssueLinkId);
                if (!deleteValidationResult.isValid()) {
                    Set reasons = deleteValidationResult.getErrorCollection().getReasons();
                    if (reasons.size() == 1 && reasons.contains(ErrorCollection.Reason.NOT_FOUND)) {
                        return RemoteIssueLinkResource.this.createNoContentResponse();
                    }
                    RemoteIssueLinkResource.this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.remote.issue.validation.failed", deleteValidationResult.getErrorCollection()));
                }
                RemoteIssueLinkResource.this.remoteIssueLinkService.delete(user, deleteValidationResult);
                return RemoteIssueLinkResource.this.createNoContentResponse();
            }
        });
    }
}

