/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.issuelink;

import com.atlassian.greenhopper.issue.link.IssueLinkTypeContextTransformer;
import com.atlassian.greenhopper.issue.link.RemoteIssueLinkSearchService;
import com.atlassian.greenhopper.service.issue.field.IssueStatusService;
import com.atlassian.greenhopper.web.rapid.issue.IssueHelper;
import com.atlassian.greenhopper.web.rapid.issue.StatusEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.issuelink.IssueLinkModel;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.plugin.viewissue.issuelink.IssueLinkContext;
import com.atlassian.jira.plugin.viewissue.issuelink.IssueLinkTypeContext;
import com.atlassian.jira.plugin.viewissue.issuelink.LocalIssueLinkUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueLinkModelFactory {
    @Autowired
    private IssueLinkManager issueLinkManager;
    @Autowired
    private JiraAuthenticationContext authenticationContext;
    @Autowired
    private FieldVisibilityManager fieldVisibilityManager;
    @Autowired
    private PermissionManager permissionManager;
    @Autowired
    private VelocityRequestContextFactory velocityRequestContextFactory;
    @Autowired
    private RemoteIssueLinkSearchService remoteIssueLinkSearchService;
    @Autowired
    private PluginAccessor pluginAccessor;
    @Autowired
    private IssueHelper issueHelper;
    @Autowired
    private IssueStatusService issueStatusService;
    @Autowired
    private StatusEntryFactory statusEntryFactory;
    private IssueLinkTypeContextTransformer issueLinkTypeContextTransformer;

    @PostConstruct
    public void onSpringContextStarted() {
        this.issueLinkTypeContextTransformer = new IssueLinkTypeContextTransformer(this.issueHelper, this.issueStatusService, this.statusEntryFactory);
    }

    public IssueLinkModel createModel(Issue issue, boolean fieldConfigured) {
        IssueLinkModel result = new IssueLinkModel();
        result.linkingEnabled = true;
        if (!this.issueLinkManager.isLinkingEnabled() || !fieldConfigured) {
            result.linkingEnabled = false;
            return result;
        }
        ApplicationUser loggedInUser = this.authenticationContext.getUser();
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        Map<String, List<IssueLinkContext>> localRelationshipIssueLinkMap = this.getLocalIssueLinks(issue, loggedInUser, baseUrl);
        Map<String, List<IssueLinkContext>> remoteRelationshipIssueLinkMap = this.remoteIssueLinkSearchService.getRemoteIssueLinkContexts(issue);
        List<IssueLinkTypeContext> issueLinkTypeContexts = this.sortLinkTypes(localRelationshipIssueLinkMap, remoteRelationshipIssueLinkMap);
        result.defaultLinkIcon = baseUrl + "/images/icons/generic_link_16.png";
        result.canLink = this.permissionManager.hasPermission(21, issue, loggedInUser);
        result.hasIssueLinks = !issueLinkTypeContexts.isEmpty();
        result.issueLinkTypeEntries = ImmutableList.copyOf((Iterable)Iterables.transform(issueLinkTypeContexts, (Function)this.issueLinkTypeContextTransformer));
        return result;
    }

    private List<IssueLinkTypeContext> sortLinkTypes(Map<String, List<IssueLinkContext>> localIssueLinks, Map<String, List<IssueLinkContext>> remoteIssueLinks) {
        ArrayList issueLinkTypeContexts = Lists.newArrayList();
        Set<String> localRelationshipSet = localIssueLinks.keySet();
        ArrayList localRelationships = Lists.newArrayList(localRelationshipSet);
        Collections.sort(localRelationships, String.CASE_INSENSITIVE_ORDER);
        for (String relationship : localRelationships) {
            ArrayList issueLinkContexts = Lists.newArrayList((Iterable)localIssueLinks.get(relationship));
            if (remoteIssueLinks.containsKey(relationship)) {
                issueLinkContexts.addAll((Collection)remoteIssueLinks.get(relationship));
            }
            issueLinkTypeContexts.add(new IssueLinkTypeContext(relationship, (List)issueLinkContexts));
        }
        Sets.SetView remoteOnlyRelationshipSet = Sets.difference(remoteIssueLinks.keySet(), localRelationshipSet);
        ArrayList remoteOnlyRelationships = Lists.newArrayList((Iterable)remoteOnlyRelationshipSet);
        Collections.sort(remoteOnlyRelationships, String.CASE_INSENSITIVE_ORDER);
        for (String relationship : remoteOnlyRelationships) {
            issueLinkTypeContexts.add(new IssueLinkTypeContext(relationship, remoteIssueLinks.get(relationship)));
        }
        return issueLinkTypeContexts;
    }

    private Map<String, List<IssueLinkContext>> getLocalIssueLinks(Issue issue, ApplicationUser loggedInUser, String baseUrl) {
        LinkCollection linkCollection = this.issueLinkManager.getLinkCollection(issue, loggedInUser);
        return LocalIssueLinkUtils.convertToIssueLinkContexts((LinkCollection)linkCollection, (Long)issue.getId(), (String)baseUrl, (FieldVisibilityManager)this.fieldVisibilityManager);
    }
}

