/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.issuelink;

import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.greenhopper.customfield.epiclabel.EpicLabelProviderImpl;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.ServiceResult;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicModel;
import com.atlassian.greenhopper.service.issuelink.EpicNamesResult;
import com.atlassian.greenhopper.service.issuelink.EpicPickerService;
import com.atlassian.greenhopper.service.issuelink.EpicService;
import com.atlassian.greenhopper.service.issuelink.IssueLinkRequest;
import com.atlassian.greenhopper.service.issuelink.IssueUnlinkRequest;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.entity.common.LinkedPagesModel;
import com.atlassian.greenhopper.web.rapid.entity.common.RemoteEntityLinkModel;
import com.atlassian.greenhopper.web.rapid.entity.epic.EpicLinkedPagesModelFactory;
import com.atlassian.greenhopper.web.rapid.issue.IssueHelper;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;

@Path(value="epics")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class EpicResource
extends AbstractResource {
    private final EpicService epicService;
    private final EpicPickerService epicPickerService;
    private final IssueTypeService issueTypeService;
    private final IssueHelper issueHelper;
    private final EpicLabelProviderImpl epicLabelProvider;
    private final EpicLinkedPagesModelFactory epicLinkedPagesModelFactory;
    private final JiraBaseUrls jiraBaseUrls;
    private final InternalHostApplication internalHostApplication;
    private final PermissionService permissionService;

    public EpicResource(EpicService epicService, EpicPickerService epicPickerService, IssueHelper issueHelper, IssueTypeService issueTypeService, EpicLabelProviderImpl epicLabelProvider, JiraBaseUrls jiraBaseUrls, InternalHostApplication internalHostApplication, PermissionService permissionService, EpicLinkedPagesModelFactory epicLinkedPagesModelFactory) {
        this.epicService = epicService;
        this.epicPickerService = epicPickerService;
        this.issueHelper = issueHelper;
        this.issueTypeService = issueTypeService;
        this.epicLabelProvider = epicLabelProvider;
        this.epicLinkedPagesModelFactory = epicLinkedPagesModelFactory;
        this.jiraBaseUrls = jiraBaseUrls;
        this.internalHostApplication = internalHostApplication;
        this.permissionService = permissionService;
    }

    @PUT
    @Path(value="{epicKey}/add")
    public Response associateIssuesToEpic(final @PathParam(value="epicKey") String epicKey, final AddToEpicRequest addToEpicRequest) {
        return this.responseWithoutAccessCheck(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = EpicResource.this.getUser();
                ServiceOutcome<Issue> epic = EpicResource.this.issueHelper.findIssue(epicKey);
                EpicResource.this.check(epic);
                List<String> issueKeys = addToEpicRequest.issueKeys;
                boolean ignoreEpics = addToEpicRequest.ignoreEpics != null ? addToEpicRequest.ignoreEpics : false;
                boolean ignoreSubtasks = addToEpicRequest.ignoreSubtasks != null ? addToEpicRequest.ignoreSubtasks : false;
                Set<Object> issues = EpicResource.this.check(EpicResource.this.issueHelper.findIssuesSet(issueKeys));
                if (issues.isEmpty()) {
                    return EpicResource.this.createNoContentResponse();
                }
                if (ignoreEpics && (issues = issues.stream().filter(issue -> !issue.getIssueTypeObject().equals(EpicResource.this.issueTypeService.getOrCreateEpicIssueType())).collect(Collectors.toSet())).isEmpty()) {
                    return EpicResource.this.createNoContentResponse();
                }
                if (ignoreSubtasks && (issues = issues.stream().filter(issue -> !issue.isSubTask()).collect(Collectors.toSet())).isEmpty()) {
                    EpicResource.this.checkResult(ServiceOutcomeImpl.error("soft-error", ErrorCollection.Reason.VALIDATION_FAILED, "gh.epic.associate.error.subtask", "<br /><br />"));
                }
                ServiceResult outcome = EpicResource.this.epicService.addIssuesToEpic(IssueLinkRequest.linkEpic(user, epic.get(), issues));
                EpicResource.this.checkResult(outcome);
                return EpicResource.this.createNoContentResponse();
            }
        });
    }

    @PUT
    @Path(value="remove")
    public Response disassociateIssuesFromEpic(RemoveFromEpicRequest removeFromEpicRequest) {
        return this.responseWithoutAccessCheck(() -> {
            ApplicationUser user = this.getUser();
            Set<Issue> issues = this.check(this.issueHelper.findIssuesSet(removeFromEpicRequest.issueKeys));
            this.checkResult(this.epicService.removeEpicFromIssues(IssueUnlinkRequest.unlinkEpic(user, issues)));
            return this.createNoContentResponse();
        });
    }

    @GET
    @Path(value="{epicKey}/pages")
    public Response getPages(final @PathParam(value="epicKey") String epicKey) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = EpicResource.this.getUser();
                Issue epic = EpicResource.this.check(EpicResource.this.issueHelper.findIssue(epicKey));
                LinkedPagesModel response = new LinkedPagesModel();
                response.jiraBaseUrl = EpicResource.this.jiraBaseUrls.baseUrl();
                response.jiraApplicationId = EpicResource.this.internalHostApplication.getId().get();
                response.applicationLinks = EpicResource.this.epicLinkedPagesModelFactory.findSupportedConfluenceApplicationLinks();
                response.pages = EpicResource.this.epicLinkedPagesModelFactory.getPages(epic, response.applicationLinks);
                response.canModifyPages = EpicResource.this.permissionService.canUpdateLinks(user, epic);
                return EpicResource.this.createOkResponse(response);
            }
        });
    }

    @POST
    @Path(value="/{epicKey}/pages")
    public Response linkPage(final @PathParam(value="epicKey") String epicKey, final LinkPageToEpicModel model) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = EpicResource.this.getUser();
                Issue epic = EpicResource.this.check(EpicResource.this.issueHelper.findIssue(epicKey));
                RemoteEntityLinkModel remoteIssueLinkModel = EpicResource.this.check(EpicResource.this.epicLinkedPagesModelFactory.linkPageToEpic(user, epic, model.pageId));
                return EpicResource.this.createOkResponse(remoteIssueLinkModel);
            }
        });
    }

    @GET
    public Response listEpics(final @QueryParam(value="searchQuery") String searchQuery, final @QueryParam(value="maxResults") int maxResults, final @QueryParam(value="projectKey") String projectKeys, final @QueryParam(value="hideDone") boolean hideDone, final @QueryParam(value="query") String query, final @QueryParam(value="filterEpicsByGivenProjects") boolean filterEpicByGivenProjects) {
        return this.responseWithoutAccessCheck(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = EpicResource.this.getUser();
                String searchTerm = (String)StringUtils.defaultIfBlank((CharSequence)searchQuery, (CharSequence)query);
                List<EpicNamesResult> epicNamesResults = EpicResource.this.check(EpicResource.this.epicPickerService.listEpicNames(user, searchTerm, maxResults, projectKeys, hideDone, filterEpicByGivenProjects));
                FindEpicNamesResponse response = new FindEpicNamesResponse();
                for (EpicNamesResult epicResult : epicNamesResults) {
                    EpicNameListModel list = new EpicNameListModel(epicResult.getListDescriptor());
                    for (EpicModel epicName : epicResult.getNames()) {
                        String key = epicName.getEpicKey();
                        String label = epicName.getEpicName();
                        label = EpicResource.this.epicLabelProvider.getEpicLabel(key, label);
                        list.epicNames.add(new EpicNameModel(key, label, epicName.isDone()));
                    }
                    response.epicLists.add(list);
                    response.total = epicResult.getTotal();
                }
                return EpicResource.this.createOkResponse(response);
            }
        });
    }

    @XmlRootElement
    public static class LinkPageToEpicModel
    extends RestTemplate {
        @XmlElement
        public String pageId;
    }

    @XmlRootElement
    public static class EpicNameModel
    extends RestTemplate {
        @XmlElement
        String key;
        @XmlElement
        String name;
        @XmlElement
        boolean isDone;

        public EpicNameModel(String key, String name, boolean isDone) {
            this.key = key;
            this.name = name;
            this.isDone = isDone;
        }
    }

    @XmlRootElement
    public static class EpicNameListModel
    extends RestTemplate {
        @XmlElement
        String listDescriptor;
        @XmlElement
        List<EpicNameModel> epicNames;

        public EpicNameListModel(String listDescriptor) {
            this.listDescriptor = listDescriptor;
            this.epicNames = new ArrayList<EpicNameModel>();
        }
    }

    @XmlRootElement
    public static class FindEpicNamesResponse
    extends RestTemplate {
        @XmlElement
        List<EpicNameListModel> epicLists = Lists.newLinkedList();
        @XmlElement
        int total;
    }

    @XmlRootElement
    public static class RemoveFromEpicRequest
    extends RestTemplate {
        @XmlElement
        List<String> issueKeys;
    }

    @XmlRootElement
    public static class AddToEpicRequest
    extends RestTemplate {
        @XmlElement
        List<String> issueKeys;
        @XmlElement
        Boolean ignoreEpics;
        @XmlElement
        Boolean ignoreSubtasks;
    }
}

