/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEditType;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.SimpleEditableFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.TextFieldEntry;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;

public class TextCustomFieldEntryFactory
implements FieldEntryFactory,
SimpleEditableFieldEntryFactory {
    private CustomField customField;
    private final FieldHelper helper;

    public TextCustomFieldEntryFactory(CustomField customField, FieldHelper helper) {
        this.customField = customField;
        this.helper = helper;
    }

    @Override
    public String getId() {
        return this.customField.getId();
    }

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        String value;
        TextFieldEntry field = new TextFieldEntry();
        field.id = this.getId();
        field.label = i18n.getText(this.customField.getNameKey());
        field.type = FieldEditType.TEXT.getKey();
        field.renderer = FieldRenderer.TEXT.getKey();
        field.text = value = (String)this.customField.getValue(issue);
        field.editable = true;
        return field;
    }

    @Override
    public FieldEntry createEditEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        return this.createViewEntry(i18n, issue, user);
    }

    @Override
    public boolean isFieldValid(Issue issue) {
        return this.helper.isCustomFieldValid(this.customField, issue);
    }

    @Override
    public void addIssueInputParameters(IssueInputParametersImpl issueInputParameters, String newValue) {
        issueInputParameters.addCustomFieldValue(this.customField.getId(), new String[]{newValue});
    }
}

