/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldDetailType;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldDetailTypeChecker;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.HtmlFieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.NonExecutableAction;
import com.atlassian.greenhopper.web.rapid.issue.fields.ReadOnlySystemFieldEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import webwork.action.Action;

public class SystemFieldEntryFactory
extends ReadOnlySystemFieldEntryFactory
implements FieldEntryFactory {
    private final OrderableField field;

    public SystemFieldEntryFactory(FieldHelper helper, OrderableField field) {
        super(helper);
        this.field = field;
    }

    @Override
    public String getId() {
        return this.field.getId();
    }

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        HtmlFieldEntry fieldEntry = new HtmlFieldEntry();
        fieldEntry.id = this.getId();
        fieldEntry.label = i18n.getText(this.field.getNameKey());
        fieldEntry.renderer = FieldRenderer.HTML.getKey();
        FieldLayoutItem fieldLayoutItem = this.fieldHelper.getFieldLayoutItem(issue, (Field)this.field);
        NonExecutableAction action = new NonExecutableAction(user);
        fieldEntry.html = Strings.emptyToNull((String)CharMatcher.whitespace().trimFrom((CharSequence)this.field.getViewHtml(fieldLayoutItem, (Action)action, issue)));
        FieldDetailType type = FieldDetailTypeChecker.getTypeFor((Field)this.field);
        fieldEntry.type = type.editType.getKey();
        fieldEntry.category = type.category.getKey();
        fieldEntry.editable = false;
        return fieldEntry;
    }
}

