/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEditType;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.SimpleEditableFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.TextFieldEntry;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.user.ApplicationUser;

public class SummaryFieldEntryFactory
implements FieldEntryFactory,
SimpleEditableFieldEntryFactory {
    @Override
    public String getId() {
        return "summary";
    }

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        TextFieldEntry field = new TextFieldEntry();
        field.id = this.getId();
        field.label = i18n.getText("gh.issue.summary");
        field.type = FieldEditType.TEXTAREA.getKey();
        field.renderer = FieldRenderer.TEXT.getKey();
        field.text = issue.getSummary();
        field.editable = true;
        return field;
    }

    @Override
    public FieldEntry createEditEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        return this.createViewEntry(i18n, issue, user);
    }

    @Override
    public boolean isFieldValid(Issue issue) {
        return true;
    }

    @Override
    public void addIssueInputParameters(IssueInputParametersImpl issueInputParameters, String newValue) {
        issueInputParameters.setSummary(newValue);
    }
}

