/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.timetracking.TimeTrackingService;
import com.atlassian.greenhopper.web.rapid.issue.fields.AbstractAggregateRemainingEstimateFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.SubTaskAwareFieldEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.TimeTrackingGraphBeanFactory;

public class SubTasksRemainingEstimateFieldEntryFactory
extends AbstractAggregateRemainingEstimateFieldEntryFactory
implements FieldEntryFactory,
SubTaskAwareFieldEntryFactory {
    private static final String SUB_TASKS_REMAINING_ESTIMATE_ID = "aggregatetimeestimate_subtasks";

    public SubTasksRemainingEstimateFieldEntryFactory(I18nHelper.BeanFactory i18nHelperFactory, TimeTrackingGraphBeanFactory timeTrackingGraphBeanFactory, AggregateTimeTrackingCalculatorFactory calculatorFactory, TimeTrackingService timeTrackingService, FieldHelper helper) {
        super(i18nHelperFactory, timeTrackingGraphBeanFactory, timeTrackingService, helper);
    }

    @Override
    public String getId() {
        return SUB_TASKS_REMAINING_ESTIMATE_ID;
    }

    @Override
    protected String getLabel(I18n2 i18n, AggregateTimeTrackingBean aggregates) {
        return i18n.getText("gh.rapid.detail.view.fields.remainingestimate.subtasks", (Object)aggregates.getSubTaskCount());
    }

    @Override
    protected Long getValue(Issue issue, AggregateTimeTrackingBean aggregates) {
        Long issueEstimate = issue.getEstimate();
        Long aggregateRemainingEstimate = aggregates.getRemainingEstimate();
        if (aggregateRemainingEstimate == null) {
            return 0L;
        }
        return aggregateRemainingEstimate - SubTasksRemainingEstimateFieldEntryFactory.nullLong(issueEstimate);
    }
}

