/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.web.rapid.issue.StatusEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.ReadOnlySystemFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.StatusFieldEntry;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;

public class StatusFieldEntryFactory
extends ReadOnlySystemFieldEntryFactory
implements FieldEntryFactory {
    private final StatusEntryFactory statusEntryFactory;

    public StatusFieldEntryFactory(FieldHelper helper, StatusEntryFactory statusEntryFactory) {
        super(helper);
        this.statusEntryFactory = statusEntryFactory;
    }

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        StatusFieldEntry field = new StatusFieldEntry();
        field.id = this.getId();
        field.label = i18n.getText("issue.field.status");
        field.renderer = FieldRenderer.STATUS.getKey();
        field.statusEntry = this.statusEntryFactory.createStatusEntry(issue);
        field.text = field.statusEntry.name;
        return field;
    }

    @Override
    public String getId() {
        return "status";
    }

    public boolean isFieldValid() {
        return true;
    }
}

