/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.HtmlFieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.ReadOnlySystemFieldEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.user.ApplicationUser;

public class ReporterFieldEntryFactory
extends ReadOnlySystemFieldEntryFactory
implements FieldEntryFactory {
    private UserFormats userFormats;

    public ReporterFieldEntryFactory(UserFormats userFormats, FieldHelper fieldHelper) {
        super(fieldHelper);
        this.userFormats = userFormats;
    }

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        HtmlFieldEntry field = new HtmlFieldEntry();
        field.id = this.getId();
        field.label = i18n.getText("issue.field.reporter");
        field.renderer = FieldRenderer.HTML.getKey();
        field.html = this.userFormats.forType("fullName").format(issue.getReporterId(), "issue-detail-view-reporter");
        return field;
    }

    @Override
    public String getId() {
        return "reporter";
    }
}

