/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.ReadOnlyFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.TextFieldEntry;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Objects;

public class ParentIssueKeyFieldEntryFactory
extends ReadOnlyFieldEntryFactory
implements FieldEntryFactory {
    public static final String PARENT_ISSUE_FIELD = "parentissuekey";

    @Override
    public String getId() {
        return PARENT_ISSUE_FIELD;
    }

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        if (Objects.nonNull(issue.getParentObject())) {
            TextFieldEntry field = new TextFieldEntry();
            field.id = this.getId();
            field.label = issue.getParentObject().getSummary();
            field.renderer = FieldRenderer.TEXT.getKey();
            field.text = issue.getParentObject().getKey();
            return field;
        }
        return null;
    }

    @Override
    public boolean isFieldValid(Issue issue) {
        return Objects.nonNull(issue.getParentObject());
    }
}

