/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.timetracking.TimeTrackingService;
import com.atlassian.greenhopper.web.rapid.issue.fields.ComplexEditableFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEditType;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.HtmlFieldEntry;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.TimeTrackingGraphBeanFactory;
import javax.annotation.Nonnull;

public class OriginalEstimateFieldEntryFactory
implements FieldEntryFactory,
ComplexEditableFieldEntryFactory {
    public static final String ORIGINAL_ESTIMATE_ID = "timeoriginalestimate";
    private I18nHelper.BeanFactory i18nHelperFactory;
    private TimeTrackingGraphBeanFactory timeTrackingGraphBeanFactory;
    private TimeTrackingService timeTrackingService;
    private FieldHelper fieldHelper;

    public OriginalEstimateFieldEntryFactory(I18nHelper.BeanFactory i18nHelperFactory, TimeTrackingGraphBeanFactory timeTrackingGraphBeanFactory, TimeTrackingService timeTrackingService, FieldHelper helper) {
        this.i18nHelperFactory = i18nHelperFactory;
        this.timeTrackingGraphBeanFactory = timeTrackingGraphBeanFactory;
        this.timeTrackingService = timeTrackingService;
        this.fieldHelper = helper;
    }

    @Override
    public String getId() {
        return ORIGINAL_ESTIMATE_ID;
    }

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        HtmlFieldEntry field = new HtmlFieldEntry();
        field.id = this.getId();
        field.label = i18n.getText("gh.rapid.config.estimation.statistic.timetracking.original");
        field.type = FieldEditType.NUMBER.getKey();
        field.renderer = FieldRenderer.DURATION.getKey();
        I18nHelper i18nHelper = this.i18nHelperFactory.getInstance(user);
        field.html = field.text = this.timeTrackingGraphBeanFactory.createBean(issue, TimeTrackingGraphBeanFactory.Style.SHORT, i18nHelper).getOriginalEstimateStr();
        field.editable = true;
        return field;
    }

    @Override
    public FieldEntry createEditEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        return this.createViewEntry(i18n, issue, user);
    }

    @Override
    public boolean isFieldValid(Issue issue) {
        return this.fieldHelper.isFieldVisible(this.getId(), issue);
    }

    @Override
    @Nonnull
    public ServiceOutcome<Void> updateField(ApplicationUser user, Issue issue, String newValue) {
        return this.timeTrackingService.updateOriginalEstimate(issue, newValue, true);
    }
}

