/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.rapid.issue.fields.ComplexEditableFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEditType;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.NumberFieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.SimpleEditableFieldEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class NumberCustomFieldEntryFactory
implements FieldEntryFactory,
SimpleEditableFieldEntryFactory,
ComplexEditableFieldEntryFactory {
    private CustomField customField;
    private FieldHelper fieldHelper;

    public NumberCustomFieldEntryFactory(CustomField customField, FieldHelper fieldHelper) {
        this.customField = customField;
        this.fieldHelper = fieldHelper;
    }

    @Override
    public String getId() {
        return this.customField.getId();
    }

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        Double value;
        NumberFieldEntry field = new NumberFieldEntry();
        field.id = this.getId();
        field.label = i18n.getText(this.customField.getNameKey());
        field.type = FieldEditType.NUMBER.getKey();
        field.renderer = FieldRenderer.TEXT.getKey();
        field.value = value = (Double)this.customField.getValue(issue);
        field.text = this.formatNumber(i18n, value);
        field.editable = true;
        return field;
    }

    @Override
    public FieldEntry createEditEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        return this.createViewEntry(i18n, issue, user);
    }

    @Override
    public boolean isFieldValid(Issue issue) {
        return this.fieldHelper.isCustomFieldValid(this.customField, issue);
    }

    @Override
    public void addIssueInputParameters(IssueInputParametersImpl issueInputParameters, String newValue) {
        issueInputParameters.addCustomFieldValue(this.customField.getId(), new String[]{newValue});
    }

    @Override
    public ServiceOutcome<Void> updateField(ApplicationUser user, Issue issue, String newValue) {
        try {
            Double doubleValue = Double.parseDouble(newValue);
            if (doubleValue < 0.0) {
                return ServiceOutcomeImpl.error(this.getId(), ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.detail.view.update.number.error.negative", new Object[0]);
            }
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        return this.fieldHelper.updateField(user, issue, this, newValue);
    }

    String formatNumber(I18n2 i18n, Double number) {
        if (number == null) {
            return null;
        }
        NumberFormat decimalFormat = DecimalFormat.getInstance(i18n.getLocale());
        String doubleString = decimalFormat.format(number);
        return "-0".equals(doubleString) ? "0" : doubleString;
    }
}

