/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.HtmlFieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.ReadOnlySystemFieldEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;

public class LabelsFieldEntryFactory
extends ReadOnlySystemFieldEntryFactory
implements FieldEntryFactory {
    public LabelsFieldEntryFactory(FieldHelper helper) {
        super(helper);
    }

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        HtmlFieldEntry field = new HtmlFieldEntry();
        field.id = this.getId();
        field.label = i18n.getText("issue.field.labels");
        field.renderer = FieldRenderer.TEXT.getKey();
        field.text = FieldHelper.renderListField(issue.getLabels(), new Function<Label, String>(){

            public String apply(Label label) {
                return label.getLabel();
            }
        });
        return field;
    }

    @Override
    public String getId() {
        return "labels";
    }
}

