/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.HtmlFieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.ReadOnlySystemFieldEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;

public class FixForVersionsFieldEntryFactory
extends ReadOnlySystemFieldEntryFactory
implements FieldEntryFactory {
    public FixForVersionsFieldEntryFactory(FieldHelper helper) {
        super(helper);
    }

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        HtmlFieldEntry field = new HtmlFieldEntry();
        field.id = this.getId();
        field.label = i18n.getText("issue.field.fixversions");
        field.renderer = FieldRenderer.TEXT.getKey();
        field.text = FieldHelper.renderListField(issue.getFixVersions(), Version::getName);
        return field;
    }

    @Override
    public String getId() {
        return "fixVersions";
    }
}

