/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueUpdateService;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.HtmlFieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.SimpleEditableFieldEntryFactory;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.base.Function;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FieldHelper {
    @Autowired
    private FieldLayoutManager fieldLayoutManager;
    @Autowired
    private RendererManager rendererManager;
    @Autowired
    private IssueUpdateService issueUpdateService;
    @Autowired
    private DateTimeFormatter dateTimeFormatterFactory;
    @Autowired
    private FieldVisibilityManager fieldVisibilityManager;
    @Autowired
    private CustomFieldService customFieldService;

    public static <T> String renderListField(Collection<T> values, Function<T, String> toStringFunction) {
        if (!values.isEmpty()) {
            CollectionBuilder builder = CollectionBuilder.newBuilder();
            for (T value : values) {
                builder.add(toStringFunction.apply(value));
            }
            return StringUtils.join((Iterable)builder.asList(), (String)", ");
        }
        return null;
    }

    public String getRenderedText(Issue issue, String fieldId, String value) {
        FieldLayoutItem fieldLayoutItem = this.getFieldLayoutItem(issue, fieldId);
        return this.rendererManager.getRendererForField(fieldLayoutItem).render(value, issue.getIssueRenderContext());
    }

    @Nonnull
    public ServiceOutcome<Void> updateField(ApplicationUser user, Issue issue, SimpleEditableFieldEntryFactory editableField, String newValue) {
        IssueInputParametersImpl issueInputParameters = new IssueInputParametersImpl();
        editableField.addIssueInputParameters(issueInputParameters, newValue);
        IssueService.UpdateValidationResult updateValidationResult = this.issueUpdateService.validateUpdate(user, issue.getId(), (IssueInputParameters)issueInputParameters);
        if (!updateValidationResult.isValid()) {
            return ServiceOutcomeImpl.fromJiraErrorCollectionWithReasons(updateValidationResult.getErrorCollection());
        }
        IssueService.IssueResult updateResult = this.issueUpdateService.update(user, updateValidationResult);
        if (!updateResult.isValid()) {
            return ServiceOutcomeImpl.fromJiraErrorCollectionWithReasons(updateResult.getErrorCollection());
        }
        return ServiceOutcomeImpl.ok();
    }

    public HtmlFieldEntry createDateFieldViewEntry(I18n2 i18n, ApplicationUser user, @Nullable Timestamp date, String id, String labelKey) {
        HtmlFieldEntry field = new HtmlFieldEntry();
        field.id = id;
        field.label = i18n.getText(labelKey);
        field.renderer = FieldRenderer.DATE.getKey();
        if (date != null) {
            DateTimeFormatter formatter = this.dateTimeFormatterFactory.forUser(user).withStyle(DateTimeStyle.ISO_8601_DATE_TIME);
            field.text = formatter.format((Date)date);
            formatter = this.dateTimeFormatterFactory.forUser(user).withStyle(DateTimeStyle.COMPLETE);
            field.html = formatter.format((Date)date);
        }
        return field;
    }

    public FieldLayoutItem getFieldLayoutItem(Issue issue, Field field) {
        return this.getFieldLayoutItem(issue, field.getId());
    }

    public FieldLayoutItem getFieldLayoutItem(Issue issue, String fieldId) {
        return this.fieldLayoutManager.getFieldLayout(issue).getFieldLayoutItem(fieldId);
    }

    public boolean isFieldVisible(Field field, Issue issue) {
        return this.isFieldVisible(field.getId(), issue);
    }

    public boolean isCustomFieldValid(CustomField field, Issue issue) {
        return this.customFieldService.isFieldApplicable(field, issue) && this.customFieldService.isFieldVisible(field, issue);
    }

    public boolean isFieldVisible(String id, Issue issue) {
        return this.fieldVisibilityManager.isFieldVisible(id, issue);
    }
}

