/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkCFType;
import com.atlassian.greenhopper.customfield.lexorank.LexoRankCFType;
import com.atlassian.greenhopper.customfield.sprint.SprintCFType;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldDetailType;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldDetailsCategory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEditType;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.impl.CascadingSelectCFType;
import com.atlassian.jira.issue.customfields.impl.DateCFType;
import com.atlassian.jira.issue.customfields.impl.DateTimeCFType;
import com.atlassian.jira.issue.customfields.impl.GenericTextCFType;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.MultiGroupCFType;
import com.atlassian.jira.issue.customfields.impl.MultiSelectCFType;
import com.atlassian.jira.issue.customfields.impl.MultiUserCFType;
import com.atlassian.jira.issue.customfields.impl.NumberCFType;
import com.atlassian.jira.issue.customfields.impl.SelectCFType;
import com.atlassian.jira.issue.customfields.impl.TextAreaCFType;
import com.atlassian.jira.issue.customfields.impl.UserCFType;
import com.atlassian.jira.issue.customfields.impl.VersionCFType;
import com.atlassian.jira.issue.fields.AffectedVersionsSystemField;
import com.atlassian.jira.issue.fields.AssigneeSystemField;
import com.atlassian.jira.issue.fields.ComponentsSystemField;
import com.atlassian.jira.issue.fields.CreatedSystemField;
import com.atlassian.jira.issue.fields.DueDateSystemField;
import com.atlassian.jira.issue.fields.EnvironmentSystemField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FixVersionsSystemField;
import com.atlassian.jira.issue.fields.IssueLinksSystemField;
import com.atlassian.jira.issue.fields.IssueTypeSystemField;
import com.atlassian.jira.issue.fields.LabelsSystemField;
import com.atlassian.jira.issue.fields.PrioritySystemField;
import com.atlassian.jira.issue.fields.ReporterSystemField;
import com.atlassian.jira.issue.fields.ResolutionDateSystemField;
import com.atlassian.jira.issue.fields.ResolutionSystemField;
import com.atlassian.jira.issue.fields.SecurityLevelSystemField;
import com.atlassian.jira.issue.fields.StatusSystemField;
import com.atlassian.jira.issue.fields.UpdatedSystemField;
import com.atlassian.jira.issue.fields.VotesSystemField;
import java.util.LinkedHashMap;
import java.util.Map;

public class FieldDetailTypeChecker {
    private static final Map<Class, FieldDetailType> detailTypeMap = new LinkedHashMap<Class, FieldDetailType>();

    public static FieldDetailType getTypeFor(CustomFieldType fieldType) {
        return FieldDetailTypeChecker.getTypeFor(fieldType.getClass());
    }

    public static FieldDetailType getTypeFor(Field fieldType) {
        return FieldDetailTypeChecker.getTypeFor(fieldType.getClass());
    }

    private static FieldDetailType getTypeFor(Class fieldType) {
        for (Map.Entry<Class, FieldDetailType> entry : detailTypeMap.entrySet()) {
            Class key = entry.getKey();
            if (!key.isAssignableFrom(fieldType)) continue;
            return entry.getValue();
        }
        return new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.UNSUPPORTED);
    }

    static {
        detailTypeMap.put(StatusSystemField.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(ComponentsSystemField.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(LabelsSystemField.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(AffectedVersionsSystemField.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(FixVersionsSystemField.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(CreatedSystemField.class, new FieldDetailType(FieldEditType.DATE, FieldDetailsCategory.DATES));
        detailTypeMap.put(UpdatedSystemField.class, new FieldDetailType(FieldEditType.DATE, FieldDetailsCategory.DATES));
        detailTypeMap.put(ReporterSystemField.class, new FieldDetailType(FieldEditType.USER, FieldDetailsCategory.PEOPLE));
        detailTypeMap.put(AssigneeSystemField.class, new FieldDetailType(FieldEditType.USER, FieldDetailsCategory.PEOPLE));
        detailTypeMap.put(VotesSystemField.class, new FieldDetailType(FieldEditType.VOTES, FieldDetailsCategory.PEOPLE));
        detailTypeMap.put(IssueLinksSystemField.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.LINKS));
        detailTypeMap.put(PrioritySystemField.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(IssueTypeSystemField.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(TextAreaCFType.class, new FieldDetailType(FieldEditType.TEXTAREA, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(GenericTextCFType.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(NumberCFType.class, new FieldDetailType(FieldEditType.NUMBER, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(ResolutionSystemField.class, new FieldDetailType(FieldEditType.RESOLUTION, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(SecurityLevelSystemField.class, new FieldDetailType(FieldEditType.SECURITY, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(EnvironmentSystemField.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(LabelsCFType.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(SelectCFType.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(MultiSelectCFType.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(VersionCFType.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(CascadingSelectCFType.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(EpicLinkCFType.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(DateCFType.class, new FieldDetailType(FieldEditType.DATE, FieldDetailsCategory.DATES));
        detailTypeMap.put(DateTimeCFType.class, new FieldDetailType(FieldEditType.DATETIME, FieldDetailsCategory.DATES));
        detailTypeMap.put(DueDateSystemField.class, new FieldDetailType(FieldEditType.DATE, FieldDetailsCategory.DATES));
        detailTypeMap.put(ResolutionDateSystemField.class, new FieldDetailType(FieldEditType.DATETIME, FieldDetailsCategory.DATES));
        detailTypeMap.put(UserCFType.class, new FieldDetailType(FieldEditType.USER, FieldDetailsCategory.PEOPLE));
        detailTypeMap.put(MultiUserCFType.class, new FieldDetailType(FieldEditType.USERS, FieldDetailsCategory.PEOPLE));
        detailTypeMap.put(MultiGroupCFType.class, new FieldDetailType(FieldEditType.GROUPS, FieldDetailsCategory.PEOPLE));
        detailTypeMap.put(UserCFType.class, new FieldDetailType(FieldEditType.USER, FieldDetailsCategory.PEOPLE));
        detailTypeMap.put(LexoRankCFType.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
        detailTypeMap.put(SprintCFType.class, new FieldDetailType(FieldEditType.TEXT, FieldDetailsCategory.DETAILS));
    }
}

