/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.web.rapid.issue.fields.EpicLinkFieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.ReadOnlyCustomFieldEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import org.apache.commons.lang3.StringUtils;

public class EpicLinkFieldEntryFactory
extends ReadOnlyCustomFieldEntryFactory
implements FieldEntryFactory {
    private final PermissionService permissionService;
    private final IssueTypeService issueTypeService;
    private final CustomField epicColorCustomField;
    private final CustomField epicLinkCustomField;

    public EpicLinkFieldEntryFactory(FieldHelper helper, CustomField epicLinkCustomField, EpicCustomFieldService epicCustomFieldService, PermissionService permissionService, IssueTypeService issueTypeService) {
        super(helper);
        Preconditions.checkNotNull((Object)helper);
        Preconditions.checkNotNull((Object)epicCustomFieldService);
        Preconditions.checkNotNull((Object)permissionService);
        this.permissionService = permissionService;
        this.issueTypeService = issueTypeService;
        this.field = epicCustomFieldService.getDefaultEpicLabelField();
        this.epicColorCustomField = epicCustomFieldService.getDefaultEpicColorField();
        this.epicLinkCustomField = epicLinkCustomField;
    }

    @Override
    public String getId() {
        return this.field.getId();
    }

    @Override
    public EpicLinkFieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        Issue epic = (Issue)issue.getCustomFieldValue(this.epicLinkCustomField);
        if (epic != null) {
            EpicLinkFieldEntry fieldEntry = this.createViewEntryBasedOnEpic(epic);
            return fieldEntry;
        }
        return this.createEmptyEntryForEpic();
    }

    private EpicLinkFieldEntry createViewEntryBasedOnEpic(Issue epic) {
        EpicLinkFieldEntry fieldEntry = new EpicLinkFieldEntry();
        fieldEntry.id = this.getId();
        fieldEntry.label = epic.getIssueTypeObject().getNameTranslation();
        fieldEntry.renderer = FieldRenderer.EPICLINK.getKey();
        fieldEntry.text = Strings.emptyToNull((String)CharMatcher.whitespace().trimFrom((CharSequence)StringUtils.defaultString((String)((String)this.field.getValue(epic)))));
        fieldEntry.epicColor = Strings.emptyToNull((String)((String)this.epicColorCustomField.getValue(epic)));
        fieldEntry.epicKey = epic.getKey();
        fieldEntry.editable = false;
        return fieldEntry;
    }

    private EpicLinkFieldEntry createEmptyEntryForEpic() {
        EpicLinkFieldEntry fieldEntry = new EpicLinkFieldEntry();
        fieldEntry.id = this.getId();
        fieldEntry.label = this.issueTypeService.getOrCreateEpicIssueType().getNameTranslation();
        fieldEntry.renderer = FieldRenderer.TEXT.getKey();
        fieldEntry.text = "";
        fieldEntry.editable = false;
        return fieldEntry;
    }

    @Override
    public boolean isFieldValid(Issue issue) {
        return !issue.isSubTask();
    }
}

