/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEditType;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.HtmlFieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.ReadOnlySystemFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.SimpleEditableFieldEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParametersImpl;
import com.atlassian.jira.user.ApplicationUser;

public class DescriptionFieldEntryFactory
extends ReadOnlySystemFieldEntryFactory
implements SimpleEditableFieldEntryFactory {
    public DescriptionFieldEntryFactory(FieldHelper helper) {
        super(helper);
    }

    @Override
    public String getId() {
        return "description";
    }

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        HtmlFieldEntry field = new HtmlFieldEntry();
        field.id = this.getId();
        field.label = i18n.getText("gh.issue.description");
        field.type = FieldEditType.TEXTAREA.getKey();
        field.renderer = FieldRenderer.HTML.getKey();
        field.html = this.fieldHelper.getRenderedText(issue, this.getId(), issue.getDescription());
        field.editable = true;
        return field;
    }

    @Override
    public FieldEntry createEditEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        HtmlFieldEntry field = new HtmlFieldEntry();
        field.id = this.getId();
        field.label = i18n.getText("gh.issue.description");
        field.type = FieldEditType.TEXTAREA.getKey();
        field.renderer = FieldRenderer.HTML.getKey();
        field.text = issue.getDescription();
        field.editable = true;
        return field;
    }

    @Override
    public void addIssueInputParameters(IssueInputParametersImpl issueInputParameters, String newValue) {
        issueInputParameters.setDescription(newValue);
    }
}

