/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.web.rapid.issue.fields.AbstractCustomFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.HtmlFieldEntry;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;

public class DefaultCustomFieldEntryFactory
extends AbstractCustomFieldEntryFactory<HtmlFieldEntry> {
    public DefaultCustomFieldEntryFactory(FieldHelper helper, CustomField field) {
        super(helper, field);
    }

    @Override
    protected HtmlFieldEntry createFieldEntry() {
        return new HtmlFieldEntry();
    }

    @Override
    protected void renderFieldEntry(I18n2 i18n, Issue issue, ApplicationUser user, HtmlFieldEntry fieldEntry) {
        fieldEntry.editable = false;
        fieldEntry.renderer = FieldRenderer.HTML.getKey();
        FieldLayoutItem fieldLayoutItem = this.fieldHelper.getFieldLayoutItem(issue, (Field)this.field);
        String viewHtml = this.field.getViewHtml(fieldLayoutItem, null, issue);
        if (viewHtml != null) {
            fieldEntry.html = Strings.emptyToNull((String)CharMatcher.whitespace().trimFrom((CharSequence)viewHtml));
        }
    }
}

