/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.HtmlFieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.ReadOnlySystemFieldEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.user.ApplicationUser;

public class AssigneeFieldEntryFactory
extends ReadOnlySystemFieldEntryFactory
implements FieldEntryFactory {
    private UserFormats userFormats;

    public AssigneeFieldEntryFactory(UserFormats userFormats, FieldHelper helper) {
        super(helper);
        this.userFormats = userFormats;
    }

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        HtmlFieldEntry field = new HtmlFieldEntry();
        field.id = this.getId();
        field.label = i18n.getText("issue.field.assignee");
        field.renderer = FieldRenderer.HTML.getKey();
        String assigneeId = issue.getAssigneeId();
        field.html = assigneeId == null ? i18n.getText("common.concepts.unassigned") : this.userFormats.forType("fullName").format(assigneeId, "issue-detail-view-assignee");
        return field;
    }

    @Override
    public String getId() {
        return "assignee";
    }
}

