/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldDetailType;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldDetailTypeChecker;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.ReadOnlyCustomFieldEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Preconditions;

public abstract class AbstractCustomFieldEntryFactory<T extends FieldEntry>
extends ReadOnlyCustomFieldEntryFactory
implements FieldEntryFactory {
    public AbstractCustomFieldEntryFactory(FieldHelper helper, CustomField field) {
        super(helper);
        Preconditions.checkNotNull((Object)helper);
        Preconditions.checkNotNull((Object)field);
        this.field = field;
    }

    @Override
    public String getId() {
        return this.field.getId();
    }

    public T createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        T fieldEntry = this.createFieldEntry();
        this.setBaseInformation(i18n, issue, user, fieldEntry);
        this.renderFieldEntry(i18n, issue, user, fieldEntry);
        return fieldEntry;
    }

    protected void setBaseInformation(I18n2 i18n, Issue issue, ApplicationUser user, T fieldEntry) {
        ((FieldEntry)fieldEntry).id = this.getId();
        ((FieldEntry)fieldEntry).label = i18n.getText(this.field.getNameKey());
        FieldDetailType type = FieldDetailTypeChecker.getTypeFor(this.field.getCustomFieldType());
        ((FieldEntry)fieldEntry).type = type.editType.getKey();
        ((FieldEntry)fieldEntry).category = type.category.getKey();
    }

    protected abstract T createFieldEntry();

    protected abstract void renderFieldEntry(I18n2 var1, Issue var2, ApplicationUser var3, T var4);
}

