/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.fields;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.timetracking.TimeTrackingService;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEditType;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldRenderer;
import com.atlassian.greenhopper.web.rapid.issue.fields.HtmlFieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.ReadOnlyFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.SubTaskAwareFieldEntryFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.TimeTrackingGraphBeanFactory;
import java.util.Collection;

public abstract class AbstractAggregateRemainingEstimateFieldEntryFactory
extends ReadOnlyFieldEntryFactory
implements FieldEntryFactory,
SubTaskAwareFieldEntryFactory {
    private final I18nHelper.BeanFactory i18nHelperFactory;
    private final TimeTrackingGraphBeanFactory timeTrackingGraphBeanFactory;
    private final TimeTrackingService timeTrackingService;
    private final FieldHelper fieldHelper;

    public AbstractAggregateRemainingEstimateFieldEntryFactory(I18nHelper.BeanFactory i18nHelperFactory, TimeTrackingGraphBeanFactory timeTrackingGraphBeanFactory, TimeTrackingService timeTrackingService, FieldHelper helper) {
        this.i18nHelperFactory = i18nHelperFactory;
        this.timeTrackingGraphBeanFactory = timeTrackingGraphBeanFactory;
        this.timeTrackingService = timeTrackingService;
        this.fieldHelper = helper;
    }

    @Override
    public abstract String getId();

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, ApplicationUser user) {
        throw new IllegalStateException("This method requires knowledge of sub tasks");
    }

    @Override
    public FieldEntry createViewEntry(I18n2 i18n, Issue issue, Collection<Issue> subTasks, ApplicationUser user) {
        HtmlFieldEntry field = new HtmlFieldEntry();
        field.id = this.getId();
        field.type = FieldEditType.NUMBER.getKey();
        field.renderer = FieldRenderer.DURATION.getKey();
        I18nHelper i18nHelper = this.i18nHelperFactory.getInstance(user);
        AggregateTimeTrackingBean aggregates = this.timeTrackingService.getAggregates(issue, subTasks);
        field.label = this.getLabel(i18n, aggregates);
        field.html = field.text = this.getValue(issue, i18nHelper, aggregates);
        field.editable = false;
        return field;
    }

    protected String getValue(Issue issue, I18nHelper i18nHelper, AggregateTimeTrackingBean aggregates) {
        Long value = this.getValue(issue, aggregates);
        if (value == null) {
            return null;
        }
        aggregates.setRemainingEstimate(value);
        return this.timeTrackingGraphBeanFactory.createBean(aggregates, TimeTrackingGraphBeanFactory.Style.SHORT, i18nHelper).getRemainingEstimateStr();
    }

    protected static long nullLong(Long l) {
        return l == null ? 0L : l;
    }

    protected abstract String getLabel(I18n2 var1, AggregateTimeTrackingBean var2);

    protected abstract Long getValue(Issue var1, AggregateTimeTrackingBean var2);

    @Override
    public boolean isFieldValid(Issue issue) {
        return this.fieldHelper.isFieldVisible(this.getId(), issue);
    }
}

