/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.attachment;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.issue.IssueHelper;
import com.atlassian.greenhopper.web.rapid.issue.attachment.Attachments;
import com.atlassian.greenhopper.web.rapid.issue.attachment.AttachmentsFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import java.util.concurrent.Callable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="xboard/issue/{issueIdOrKey}/attachments")
@AnonymousAllowed
@Produces(value={"application/json"})
public class AttachmentsResource
extends AbstractResource {
    private AttachmentsFactory attachmentsFactory;
    private IssueHelper issueHelper;

    public AttachmentsResource(AttachmentsFactory attachmentsFactory, IssueHelper issueHelper) {
        this.attachmentsFactory = attachmentsFactory;
        this.issueHelper = issueHelper;
    }

    @GET
    public Response getAttachmentData(final @PathParam(value="issueIdOrKey") String idOrKey) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = AttachmentsResource.this.getUser();
                ServiceOutcome<Issue> issue = AttachmentsResource.this.issueHelper.findIssue(idOrKey);
                AttachmentsResource.this.check(issue);
                ServiceOutcome<Attachments> attachments = AttachmentsResource.this.attachmentsFactory.getAttachments(user, issue.getValue());
                AttachmentsResource.this.check(attachments);
                return AttachmentsResource.this.createOkResponse(attachments.getValue());
            }
        });
    }
}

