/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue.attachment;

import com.atlassian.core.util.FileSize;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.issue.util.AttachmentZipExtractor;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.rapid.issue.IconEntry;
import com.atlassian.greenhopper.web.rapid.issue.attachment.AttachmentEntry;
import com.atlassian.greenhopper.web.rapid.issue.attachment.Attachments;
import com.atlassian.jira.bc.issue.attachment.FileNameBasedVersionedAttachmentsList;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentFileNameCreationDateComparator;
import com.atlassian.jira.issue.attachment.AttachmentItem;
import com.atlassian.jira.issue.attachment.AttachmentItems;
import com.atlassian.jira.issue.attachment.AttachmentsCategoriser;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.web.util.FileIconBean;
import com.atlassian.jira.web.util.FileIconUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AttachmentsFactory {
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    private AttachmentManager attachmentManager;
    @Autowired
    private JiraAuthenticationContext authenticationContext;
    @Autowired
    private ThumbnailManager thumbnailManager;
    @Autowired
    private UserManager userManager;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private FileIconUtil fileIconUtil;
    @Autowired
    private AttachmentZipExtractor attachmentZipExtractor;
    @Autowired
    private DateTimeFormatter dateTimeFormatterService;

    public ServiceOutcome<Attachments> getAttachments(ApplicationUser user, final Issue issue) {
        AttachmentsCategoriser attachments = new AttachmentsCategoriser(this.thumbnailManager, new AttachmentsCategoriser.Source(){

            public List<Attachment> getAttachments() {
                return AttachmentsFactory.this.attachmentManager.getAttachments(issue, AttachmentsFactory.this.attachmentComparator());
            }
        });
        DateTimeFormatter dateTimeFormatter = this.dateTimeFormatterService.forLoggedInUser().withStyle(DateTimeStyle.COMPLETE);
        boolean zipEnabled = this.getZipSupport();
        ServiceOutcome<List<AttachmentEntry>> imageAttachments = this.convertToSimpleAttachments(dateTimeFormatter, issue, attachments.itemsThatHaveThumbs(), zipEnabled, user);
        if (!imageAttachments.isValid()) {
            return ServiceOutcomeImpl.error(imageAttachments);
        }
        ServiceOutcome<List<AttachmentEntry>> fileAttachments = this.convertToSimpleAttachments(dateTimeFormatter, issue, attachments.itemsThatDoNotHaveThumbs(), zipEnabled, user);
        if (!fileAttachments.isValid()) {
            return ServiceOutcomeImpl.error(fileAttachments);
        }
        Attachments attachmentEntries = new Attachments();
        attachmentEntries.issueId = issue.getId();
        attachmentEntries.imageAttachments = imageAttachments.getValue();
        attachmentEntries.fileAttachments = fileAttachments.getValue();
        attachmentEntries.totalCount = attachmentEntries.fileAttachments.size() + attachmentEntries.imageAttachments.size();
        return ServiceOutcomeImpl.ok(attachmentEntries);
    }

    protected Comparator<Attachment> attachmentComparator() {
        return new AttachmentFileNameCreationDateComparator(this.authenticationContext.getLocale());
    }

    private ServiceOutcome<List<AttachmentEntry>> convertToSimpleAttachments(DateTimeFormatter dateTimeFormatter, Issue issue, AttachmentItems items, boolean zipEnabled, ApplicationUser user) {
        FileNameBasedVersionedAttachmentsList attachmentsList = new FileNameBasedVersionedAttachmentsList(items.attachments());
        CollectionBuilder builder = CollectionBuilder.newBuilder();
        for (AttachmentItem item : items) {
            boolean latestVersion;
            ServiceOutcome<AttachmentEntry> attachmentEntry = this.createAttachment(dateTimeFormatter, issue, item, latestVersion = attachmentsList.isLatestVersion(item.attachment()), zipEnabled);
            if (!attachmentEntry.isValid()) {
                return ServiceOutcomeImpl.error(attachmentEntry);
            }
            builder.add((Object)attachmentEntry.getValue());
        }
        return ServiceOutcomeImpl.ok(builder.asList());
    }

    private ServiceOutcome<AttachmentEntry> createAttachment(DateTimeFormatter dateTimeFormatter, Issue issue, AttachmentItem item, boolean latestVersion, boolean zipEnabled) {
        Attachment attachment = item.attachment();
        AttachmentEntry attachmentEntry = new AttachmentEntry();
        attachmentEntry.id = attachment.getId();
        attachmentEntry.filename = attachment.getFilename();
        attachmentEntry.url = this.createAttachmentUrl(attachment);
        attachmentEntry.filesize = FileSize.format((Long)attachment.getFilesize());
        attachmentEntry.author = attachment.getAuthor();
        attachmentEntry.displayAuthor = this.getDisplayAuthor(attachment);
        attachmentEntry.latest = latestVersion;
        attachmentEntry.createdFormatted = this.getCreatedFormatted(dateTimeFormatter, attachment);
        attachmentEntry.icon = this.getIcon(attachment);
        if (zipEnabled) {
            ServiceOutcome<AttachmentEntry.ZipContents> zipContents = this.getZipContents(issue, item);
            if (!zipContents.isValid()) {
                return ServiceOutcomeImpl.error(zipContents);
            }
            attachmentEntry.zipContents = zipContents.getValue();
        }
        boolean bl = attachmentEntry.expanded = attachmentEntry.zipContents != null;
        if (item.isThumbnailAvailable()) {
            Thumbnail thumbnail = item.thumbnail();
            AttachmentEntry.Thumbnail t = new AttachmentEntry.Thumbnail();
            t.width = thumbnail.getWidth();
            t.height = thumbnail.getHeight();
            t.url = this.createThumbnailUrl(attachment, thumbnail);
            attachmentEntry.thumbnail = t;
        }
        return ServiceOutcomeImpl.ok(attachmentEntry);
    }

    private String getDisplayAuthor(Attachment attachment) {
        ApplicationUser userObject = attachment.getAuthorObject();
        return userObject == null ? attachment.getAuthor() : userObject.getDisplayName();
    }

    private String getCreatedFormatted(DateTimeFormatter dateTimeFormatter, Attachment attachment) {
        return dateTimeFormatter.format((Date)attachment.getCreated());
    }

    private ServiceOutcome<AttachmentEntry.ZipContents> getZipContents(Issue issue, AttachmentItem item) {
        Option<AttachmentZipExtractor.ZipContents> zipContents = this.attachmentZipExtractor.getZipContents(item.attachment(), issue);
        return ServiceOutcomeImpl.ok(zipContents.map(this.toLocalZipContents()).getOrNull());
    }

    private boolean getZipSupport() {
        return this.applicationProperties.getOption("jira.attachment.allow.zip.support");
    }

    private IconEntry getIcon(Attachment attachment) {
        FileIconBean.FileIcon fileIcon = this.fileIconUtil.getFileIcon(attachment.getFilename(), attachment.getMimetype());
        return this.getIcon(fileIcon);
    }

    private IconEntry getIcon(FileIconBean.FileIcon fileIcon) {
        return new IconEntry("/images/icons/attach/" + (fileIcon == null ? "file.gif" : fileIcon.getIcon()), fileIcon == null ? "File" : fileIcon.getAltText());
    }

    private String createAttachmentUrl(Attachment attachment) {
        return String.format("/secure/attachment/%d/%s", attachment.getId(), JiraUrlCodec.encode((String)attachment.getFilename()));
    }

    private String createThumbnailUrl(Attachment attachment, Thumbnail thumbnail) {
        return String.format("/secure/thumbnail/%d/%s", attachment.getId(), thumbnail.getFilename());
    }

    private Function<AttachmentZipExtractor.ZipContents, AttachmentEntry.ZipContents> toLocalZipContents() {
        return new Function<AttachmentZipExtractor.ZipContents, AttachmentEntry.ZipContents>(){

            public AttachmentEntry.ZipContents apply(AttachmentZipExtractor.ZipContents input) {
                AttachmentEntry.ZipContents contents = new AttachmentEntry.ZipContents();
                contents.maxShown = input.getMaxShown();
                contents.moreAvailable = input.isMoreAvailable();
                contents.totalNumEntries = input.getTotalNumEntries();
                contents.entries = Lists.newArrayList();
                for (AttachmentZipExtractor.ZipEntry inputEntry : input.getEntries()) {
                    AttachmentEntry.ZipEntry entry = new AttachmentEntry.ZipEntry();
                    entry.abbreviatedName = inputEntry.getAbbreviatedName();
                    entry.filesize = inputEntry.getFilesize();
                    entry.icon = new IconEntry(inputEntry.getIcon().getUrl(), inputEntry.getIcon().getAlt());
                    entry.name = inputEntry.getName();
                    entry.url = inputEntry.getUrl();
                    contents.entries.add(entry);
                }
                return contents;
            }
        };
    }
}

