/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.rapid.issue.IssueTransitions;
import com.atlassian.greenhopper.web.rapid.issue.TransitionEntry;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.workflow.IssueWorkflowManager;
import com.atlassian.jira.workflow.WorkflowManager;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransitionEntryFactory {
    @Autowired
    private IssueService issueService;
    @Autowired
    private WorkflowManager workflowManager;
    @Autowired
    private IssueWorkflowManager issueWorkflowManager;
    @Autowired
    private I18nFactoryService i18nFactoryService;

    public ServiceOutcome<IssueTransitions> buildTransitions(ApplicationUser user, Long issueId) {
        IssueService.IssueResult result = this.issueService.getIssue(user, issueId);
        if (result.getErrorCollection().hasAnyErrors()) {
            return ServiceOutcomeImpl.from(result.getErrorCollection());
        }
        MutableIssue issue = result.getIssue();
        return ServiceOutcomeImpl.ok(this.createEntry(user, (Issue)issue));
    }

    private IssueTransitions createEntry(ApplicationUser user, Issue issue) {
        IssueTransitions entry = new IssueTransitions();
        entry.issueId = issue.getId();
        entry.transitions = this.getTransitions(user, issue);
        return entry;
    }

    private List<TransitionEntry> getTransitions(ApplicationUser user, Issue issue) {
        Collection actionDescriptors = this.issueWorkflowManager.getAvailableActions(issue);
        ArrayList<TransitionEntry> transitions = new ArrayList<TransitionEntry>();
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        WorkflowDescriptor wd = this.workflowManager.getWorkflow(issue).getDescriptor();
        for (ActionDescriptor entry : actionDescriptors) {
            Integer id = entry.getId();
            TransitionEntry transition = new TransitionEntry();
            transition.id = id;
            transition.name = this.getTransitionName(i18n, entry);
            int targetStepId = entry.getUnconditionalResult().getStep();
            String statusIdString = targetStepId < 1 ? issue.getStatusObject().getId() : (String)wd.getStep(targetStepId).getMetaAttributes().get("jira.status.id");
            transition.targetStatus = Integer.parseInt(statusIdString);
            transition.hasTransitionView = StringUtils.isNotBlank((CharSequence)entry.getView());
            transitions.add(transition);
        }
        return transitions;
    }

    private String getTransitionName(I18n2 i18n, ActionDescriptor descriptor) {
        String key;
        String value;
        Map metadata = descriptor.getMetaAttributes();
        if (metadata.containsKey("jira.i18n.title") && (value = i18n.getText(key = (String)metadata.get("jira.i18n.title"))) != null && !"".equals(value.trim()) && !value.trim().equals(key.trim())) {
            return value;
        }
        return descriptor.getName();
    }
}

