/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.service.timetracking.TimeTrackingService;
import com.atlassian.greenhopper.service.user.GHAvatarService;
import com.atlassian.greenhopper.web.rapid.issue.StatusEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.SubtaskEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.RemainingEstimateFieldEntryFactory;
import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.TimeEstimateSystemField;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.TimeTrackingGraphBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubtaskEntryFactory {
    @Autowired
    private WebUtilities webUtilities;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private GHAvatarService avatarService;
    @Autowired
    private TrackingStatisticService trackingStatisticService;
    @Autowired
    private I18nHelper.BeanFactory i18nHelperFactory;
    @Autowired
    private TimeTrackingGraphBeanFactory timeTrackingGraphBeanFactory;
    @Autowired
    private TimeTrackingService timeTrackingService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private FieldHelper fieldHelper;
    @Autowired
    private StatusEntryFactory statusEntryFactory;

    public SubtaskEntry createSubtaskEntry(ApplicationUser user, Issue issue, StatisticsField trackingStatistic) {
        SubtaskEntry entry = new SubtaskEntry();
        entry.id = issue.getId();
        entry.key = issue.getKey();
        entry.done = issue.getResolutionObject() != null;
        entry.summary = issue.getSummary();
        this.handleIssueType(issue, entry);
        this.handleAssignee(issue, entry);
        this.handleStatus(issue, entry);
        this.handleTracking(issue, entry, trackingStatistic, user);
        entry.canEdit = this.permissionService.hasPermission(user, issue, 12);
        entry.canDelete = this.permissionService.hasPermission(user, issue, 16);
        return entry;
    }

    private void handleIssueType(Issue issue, SubtaskEntry entry) {
        IssueType issueType = issue.getIssueTypeObject();
        SubtaskEntry.IssueTypeEntry typeEntry = new SubtaskEntry.IssueTypeEntry();
        typeEntry.id = issueType.getId();
        typeEntry.name = issueType.getNameTranslation();
        typeEntry.url = this.webUtilities.convertRelativeUrlToAbsolute(issueType.getIconUrl());
        entry.type = typeEntry;
    }

    private void handleStatus(Issue issue, SubtaskEntry entry) {
        entry.status = this.statusEntryFactory.createStatusEntry(issue);
    }

    private void handleAssignee(Issue issue, SubtaskEntry entry) {
        ApplicationUser assignee = issue.getAssignee();
        if (assignee != null) {
            entry.assignee = this.getUserEntry(assignee);
        }
    }

    private SubtaskEntry.UserEntry getUserEntry(ApplicationUser user) {
        SubtaskEntry.UserEntry userEntry = new SubtaskEntry.UserEntry();
        userEntry.id = user.getName();
        userEntry.name = user.getDisplayName();
        userEntry.avatar = this.avatarService.getSmallAvatarURL(user);
        return userEntry;
    }

    private void handleTracking(Issue issue, SubtaskEntry entry, StatisticsField trackingStatistic, ApplicationUser user) {
        if (!this.trackingStatisticService.isTrackingStatisticValidAndEnabled(trackingStatistic)) {
            return;
        }
        if (!trackingStatistic.isFieldBased()) {
            return;
        }
        if (this.trackingStatisticService.isTrackingStatisticFieldAndNotApplicable(trackingStatistic, issue)) {
            return;
        }
        Field jiraField = trackingStatistic.getField();
        if (jiraField instanceof TimeEstimateSystemField) {
            I18n2 i18n = this.i18nFactoryService.getI18n(user);
            RemainingEstimateFieldEntryFactory remainingEstimateField = new RemainingEstimateFieldEntryFactory(this.i18nHelperFactory, this.timeTrackingGraphBeanFactory, this.timeTrackingService, this.fieldHelper);
            entry.trackingField = remainingEstimateField.createViewEntry(i18n, issue, user);
        }
    }
}

