/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue;

import com.atlassian.greenhopper.issue.fields.status.IssueStatus;
import com.atlassian.greenhopper.service.issue.field.IssueStatusService;
import com.atlassian.greenhopper.web.rapid.issue.StatusCategoryEntry;
import com.atlassian.greenhopper.web.rapid.issue.StatusEntry;
import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.status.Status;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatusEntryFactory {
    @Autowired
    private WebUtilities webUtilities;
    @Autowired
    private IssueStatusService issueStatusService;

    public StatusEntry createStatusEntry(Issue issue) {
        if (issue == null) {
            return null;
        }
        return this.createStatusEntry(issue.getStatusObject());
    }

    public StatusEntry createStatusEntry(Status status) {
        if (status == null) {
            return null;
        }
        IssueStatus issueStatus = this.issueStatusService.getIssueStatus(status);
        return this.createStatusEntry(issueStatus);
    }

    public StatusEntry createStatusEntry(IssueStatus issueStatus) {
        if (issueStatus == null) {
            return null;
        }
        StatusEntry statusEntry = new StatusEntry();
        statusEntry.id = issueStatus.getId();
        statusEntry.name = issueStatus.getName();
        statusEntry.description = issueStatus.getDescription();
        statusEntry.iconUrl = this.webUtilities.convertRelativeUrlToAbsolute(issueStatus.getIconUrl());
        statusEntry.statusCategory = StatusCategoryEntry.from(issueStatus.statusCategory);
        return statusEntry;
    }
}

