/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue;

import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.rapid.StatisticsFieldConfig;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.web.rapid.issue.statistics.DocumentStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.HistoricalEstimateStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.IssueStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.jira.issue.Issue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StatisticFieldHelper {
    private static final RapidIssueEntry.StatisticFieldValue ISSUE_COUNT_STATISTIC_FIELD_VALUE = new RapidIssueEntry.StatisticFieldValue(StatisticsFieldConfig.Type.ISSUE_COUNT.getId(), new RapidIssueEntry.NumberFieldValue(1.0));
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private TrackingStatisticService trackingStatisticService;

    public String getEstimateStatisticFieldId(StatisticsField estimateStatistic, Issue issue) {
        if (!this.estimateStatisticService.isEstimateStatisticValidAndEnabled(estimateStatistic)) {
            return null;
        }
        if (this.estimateStatisticService.isEstimateStatisticFieldAndNotApplicable(estimateStatistic, issue)) {
            return null;
        }
        if (estimateStatistic.getConfig().getType() == StatisticsFieldConfig.Type.ISSUE_COUNT) {
            return StatisticsFieldConfig.Type.ISSUE_COUNT.getId();
        }
        return estimateStatistic.getField().getId();
    }

    public String getTrackingStatisticFieldId(StatisticsField trackingStatistic, Issue issue) {
        if (!this.trackingStatisticService.isTrackingStatisticValidAndEnabled(trackingStatistic)) {
            return null;
        }
        if (this.trackingStatisticService.isTrackingStatisticFieldAndNotApplicable(trackingStatistic, issue)) {
            return null;
        }
        return trackingStatistic.getField().getId();
    }

    public RapidIssueEntry.StatisticFieldValue createEstimateStatistic(final Issue issue, final IssueStatisticValueResolver issueStatisticValueResolver) {
        EnclosedValueResolver enclosedValueResolver = new EnclosedValueResolver(){

            @Override
            public Double getValue() {
                return issueStatisticValueResolver.getValue(issue);
            }

            @Override
            public String getText(Double value) {
                return issueStatisticValueResolver.getText(value);
            }
        };
        return this.createEstimateStatistic(issueStatisticValueResolver.getStatisticsField(), issue.getProjectObject().getId(), issue.getIssueTypeObject().getId(), enclosedValueResolver);
    }

    public RapidIssueEntry.StatisticFieldValue createCurrentEstimateStatistic(final Issue issue, final HistoricalEstimateStatisticValueResolver issueStatisticValueResolver) {
        EnclosedValueResolver enclosedValueResolver = new EnclosedValueResolver(){

            @Override
            public Double getValue() {
                return issueStatisticValueResolver.getCurrentEstimation(issue.getKey());
            }

            @Override
            public String getText(Double value) {
                return issueStatisticValueResolver.getText(value);
            }
        };
        return this.createEstimateStatistic(issueStatisticValueResolver.getStatisticsField(), issue.getProjectObject().getId(), issue.getIssueTypeObject().getId(), enclosedValueResolver);
    }

    public RapidIssueEntry.StatisticFieldValue createEstimateStatistic(Long projectId, String issueTypeId, final String documentValue, final DocumentStatisticValueResolver documentStatisticValueResolver) {
        EnclosedValueResolver enclosedValueResolver = new EnclosedValueResolver(){

            @Override
            public Double getValue() {
                return documentStatisticValueResolver.getValue(documentValue);
            }

            @Override
            public String getText(Double value) {
                return documentStatisticValueResolver.getText(value);
            }
        };
        return this.createEstimateStatistic(documentStatisticValueResolver.getStatisticsField(), projectId, issueTypeId, enclosedValueResolver);
    }

    public RapidIssueEntry.StatisticFieldValue createTrackingStatistic(Long projectId, String issueTypeId, final String documentValue, final DocumentStatisticValueResolver documentStatisticValueResolver) {
        EnclosedValueResolver enclosedValueResolver = new EnclosedValueResolver(){

            @Override
            public Double getValue() {
                return documentStatisticValueResolver.getValue(documentValue);
            }

            @Override
            public String getText(Double value) {
                return documentStatisticValueResolver.getText(value);
            }
        };
        return this.createTrackingStatistic(documentStatisticValueResolver.getStatisticsField(), projectId, issueTypeId, enclosedValueResolver);
    }

    public RapidIssueEntry.StatisticFieldValue createTrackingStatisticValue(final DocumentStatisticValueResolver documentStatisticValueResolver, Long projectId, String issueTypeId, final Double value) {
        EnclosedValueResolver enclosedValueResolver = new EnclosedValueResolver(){

            @Override
            public Double getValue() {
                return value;
            }

            @Override
            public String getText(Double value2) {
                return documentStatisticValueResolver.getText(value2);
            }
        };
        return this.createTrackingStatistic(documentStatisticValueResolver.getStatisticsField(), projectId, issueTypeId, enclosedValueResolver);
    }

    private RapidIssueEntry.StatisticFieldValue createEstimateStatistic(StatisticsField estimateStatistic, Long projectId, String issueTypeId, EnclosedValueResolver enclosedValueResolver) {
        if (!this.estimateStatisticService.isEstimateStatisticValidAndEnabled(estimateStatistic)) {
            return null;
        }
        if (this.estimateStatisticService.isEstimateStatisticFieldAndNotApplicable(estimateStatistic, projectId, issueTypeId)) {
            return null;
        }
        if (estimateStatistic.getConfig().getType() == StatisticsFieldConfig.Type.ISSUE_COUNT) {
            return this.createIssueCountEstimateStatistic();
        }
        Double value = enclosedValueResolver.getValue();
        String text = null;
        if (value != null) {
            text = enclosedValueResolver.getText(value);
        }
        RapidIssueEntry.NumberFieldValue nfv = new RapidIssueEntry.NumberFieldValue(value, text);
        return new RapidIssueEntry.StatisticFieldValue(estimateStatistic.getField().getId(), nfv);
    }

    public RapidIssueEntry.StatisticFieldValue createTrackingStatistic(StatisticsField estimateStatistic, Long projectId, String issueTypeId, EnclosedValueResolver enclosedValueResolver) {
        if (!this.trackingStatisticService.isTrackingStatisticValidAndEnabled(estimateStatistic)) {
            return null;
        }
        if (this.trackingStatisticService.isTrackingStatisticFieldAndNotApplicable(estimateStatistic, projectId, issueTypeId)) {
            return null;
        }
        if (estimateStatistic.getConfig().getType() == StatisticsFieldConfig.Type.ISSUE_COUNT) {
            return this.createIssueCountEstimateStatistic();
        }
        Double value = enclosedValueResolver.getValue();
        String text = null;
        if (value != null) {
            text = enclosedValueResolver.getText(value);
        }
        RapidIssueEntry.NumberFieldValue nfv = new RapidIssueEntry.NumberFieldValue(value, text);
        return new RapidIssueEntry.StatisticFieldValue(estimateStatistic.getField().getId(), nfv);
    }

    public RapidIssueEntry.StatisticFieldValue createIssueCountEstimateStatistic() {
        return ISSUE_COUNT_STATISTIC_FIELD_VALUE;
    }

    static interface EnclosedValueResolver {
        public Double getValue();

        public String getText(Double var1);
    }
}

