/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue;

import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.model.rapid.KanbanBacklogColumn;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.ColumnService;
import com.atlassian.greenhopper.service.rapid.view.RapidViewService;
import com.atlassian.greenhopper.service.rapid.view.detailview.DetailViewFieldService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintIssueService;
import com.atlassian.greenhopper.web.AbstractResource;
import com.atlassian.greenhopper.web.rapid.RestTemplate;
import com.atlassian.greenhopper.web.rapid.issue.IssueEntry;
import com.atlassian.greenhopper.web.rapid.issue.IssueEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.IssueHelper;
import com.atlassian.greenhopper.web.rapid.issue.IssueSubtasksResolved;
import com.atlassian.greenhopper.web.rapid.issue.IssueTransitions;
import com.atlassian.greenhopper.web.rapid.issue.TransitionEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldUpdatedEntry;
import com.atlassian.greenhopper.web.rapid.issue.tabs.TabModelFactoryFactory;
import com.atlassian.greenhopper.web.rapid.issue.tabs.editable.DetailsViewTab;
import com.atlassian.greenhopper.web.rapid.work.PoolService;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@Path(value="xboard/issue")
@AnonymousAllowed
@Produces(value={"application/json"})
public class IssueResource
extends AbstractResource {
    private static final LoggerWrapper LOG = LoggerWrapper.with(IssueResource.class);
    private IssueEntryFactory issueEntryFactory;
    private TransitionEntryFactory transitionEntryFactory;
    private IssueHelper issueHelper;
    private RapidViewService rapidViewService;
    private PoolService poolService;
    private EstimateStatisticService estimateStatisticService;
    private SprintIssueService sprintIssueService;
    private TrackingStatisticService trackingStatisticService;
    private com.atlassian.greenhopper.service.version.VersionService versionService;
    private IssueService issueService;
    private VersionService jiraVersionService;
    private final RapidViewQueryService rapidViewQueryService;
    private final SearchService searchService;
    private final TabModelFactoryFactory tabModelFactoryFactory;
    private final DetailViewFieldService detailViewFieldService;
    private final ColumnService columnService;

    public IssueResource(IssueEntryFactory issueEntryFactory, TransitionEntryFactory transitionEntryFactory, IssueHelper issueHelper, RapidViewService rapidViewService, PoolService poolService, EstimateStatisticService estimateStatisticService, SprintIssueService sprintIssueService, TrackingStatisticService trackingStatisticService, com.atlassian.greenhopper.service.version.VersionService versionService, VersionService jiraVersionService, IssueService issueService, RapidViewQueryService rapidViewQueryService, SearchService searchService, TabModelFactoryFactory tabModelFactoryFactory, DetailViewFieldService detailViewFieldService, ColumnService columnService) {
        this.issueEntryFactory = issueEntryFactory;
        this.transitionEntryFactory = transitionEntryFactory;
        this.issueHelper = issueHelper;
        this.rapidViewService = rapidViewService;
        this.poolService = poolService;
        this.estimateStatisticService = estimateStatisticService;
        this.sprintIssueService = sprintIssueService;
        this.trackingStatisticService = trackingStatisticService;
        this.versionService = versionService;
        this.issueService = issueService;
        this.jiraVersionService = jiraVersionService;
        this.rapidViewQueryService = rapidViewQueryService;
        this.searchService = searchService;
        this.tabModelFactoryFactory = tabModelFactoryFactory;
        this.detailViewFieldService = detailViewFieldService;
        this.columnService = columnService;
    }

    @Path(value="/details")
    @GET
    public Response getPageData(final @Context Request request, final @QueryParam(value="issueIdOrKey") String issueIdOrKey, final @QueryParam(value="rapidViewId") Long rapidViewId, final @QueryParam(value="loadSubtasks") boolean loadSubtasks) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = IssueResource.this.getUser();
                Issue issue = IssueResource.this.check(IssueResource.this.issueHelper.findIssue(issueIdOrKey));
                EntityTag eTag = new EntityTag(Long.toHexString(issue.getUpdated().getTime()), true);
                Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
                if (builder != null) {
                    return builder.build();
                }
                RapidView rapidView = IssueResource.this.check(IssueResource.this.rapidViewService.getRapidView(user, rapidViewId));
                Option<Sprint> activeFutureSprint = IssueResource.this.check(IssueResource.this.sprintIssueService.getActiveOrFutureSprintForIssue(user, issue));
                StatisticsField estimateStatistic = IssueResource.this.estimateStatisticService.getEstimateStatistic(rapidView);
                StatisticsField trackingStatistic = IssueResource.this.trackingStatisticService.getTrackingStatistic(rapidView);
                IssueEntry issueEntry = IssueResource.this.check(IssueResource.this.issueEntryFactory.buildViewEntry(user, rapidView, issue, estimateStatistic, trackingStatistic, loadSubtasks, activeFutureSprint));
                return IssueResource.this.createOkResponse(issueEntry, eTag);
            }
        });
    }

    @Path(value="/details/{tabId}")
    @GET
    public Response getPageData(@Context Request request, final @QueryParam(value="issueIdOrKey") String issueIdOrKey, final @QueryParam(value="rapidViewId") Long rapidViewId, @QueryParam(value="loadSubtasks") boolean loadSubtasks, final @PathParam(value="tabId") String tabId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = IssueResource.this.getUser();
                Issue issue = IssueResource.this.check(IssueResource.this.issueHelper.findIssue(issueIdOrKey));
                RapidView rapidView = IssueResource.this.check(IssueResource.this.rapidViewService.getRapidView(user, rapidViewId));
                StatisticsField estimateStatistic = IssueResource.this.estimateStatisticService.getEstimateStatistic(rapidView);
                StatisticsField trackingStatistic = IssueResource.this.trackingStatisticService.getTrackingStatistic(rapidView);
                List<? extends Field> detailsViewVisibleFields = IssueResource.this.check(IssueResource.this.detailViewFieldService.getDetailViewFields(rapidView));
                return IssueResource.this.createOkResponse(IssueResource.this.tabModelFactoryFactory.newFactory().createModelPerTab(rapidView, issue, detailsViewVisibleFields, estimateStatistic, trackingStatistic, DetailsViewTab.valueOf(tabId.toUpperCase())));
            }
        });
    }

    @Path(value="/subtasksInFinalColumn")
    @GET
    public Response areSubtasksResolved(final @QueryParam(value="issueId") Long issueId, final @QueryParam(value="rapidViewId") Long rapidViewId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = IssueResource.this.getUser();
                RapidView rapidView = IssueResource.this.check(IssueResource.this.rapidViewService.getRapidView(user, rapidViewId));
                IssueSubtasksResolved subtasksResolved = IssueResource.this.check(IssueResource.this.poolService.areIssueSubtasksInFinalColumn(user, rapidView, issueId));
                return IssueResource.this.createOkResponse(subtasksResolved);
            }
        });
    }

    @Path(value="/transitions")
    @GET
    public Response getTransitions(final @QueryParam(value="issueId") Long issueId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ServiceOutcome<IssueTransitions> transitions = IssueResource.this.transitionEntryFactory.buildTransitions(IssueResource.this.getUser(), issueId);
                IssueResource.this.check(transitions);
                return IssueResource.this.createOkResponse(transitions.getValue());
            }
        });
    }

    @Path(value="/edit-data")
    @GET
    public Response getEditData(final @Context Request request, final @QueryParam(value="issueIdOrKey") String issueIdOrKey, final @QueryParam(value="rapidViewId") Long rapidViewId) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = IssueResource.this.getUser();
                Issue issue = IssueResource.this.check(IssueResource.this.issueHelper.findIssue(issueIdOrKey));
                EntityTag eTag = new EntityTag(Long.toHexString(issue.getUpdated().getTime()), true);
                Response.ResponseBuilder builder = request.evaluatePreconditions(eTag);
                if (builder != null) {
                    return builder.build();
                }
                RapidView rapidView = IssueResource.this.check(IssueResource.this.rapidViewService.getRapidView(user, rapidViewId));
                Option<Sprint> activeFutureSprint = IssueResource.this.check(IssueResource.this.sprintIssueService.getActiveSprintForIssue(user, issue));
                StatisticsField estimateStatistic = IssueResource.this.estimateStatisticService.getEstimateStatistic(rapidView);
                StatisticsField trackingStatistic = IssueResource.this.trackingStatisticService.getTrackingStatistic(rapidView);
                IssueEntry issueEntry = IssueResource.this.issueEntryFactory.buildEditEntry(user, issue, estimateStatistic, trackingStatistic, activeFutureSprint.isDefined());
                return IssueResource.this.createOkResponse(issueEntry, eTag);
            }
        });
    }

    @Path(value="/update-field")
    @PUT
    public Response updateField(final UpdateFieldRequest updateFieldRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = IssueResource.this.getUser();
                Issue issue = IssueResource.this.check(IssueResource.this.issueHelper.findIssue(updateFieldRequest.issueIdOrKey));
                FieldUpdatedEntry result = IssueResource.this.check(IssueResource.this.issueEntryFactory.updateField(user, issue, updateFieldRequest.fieldId, updateFieldRequest.newValue));
                return IssueResource.this.createOkResponse(result);
            }
        });
    }

    @PUT
    @Path(value="fixversion/set")
    public Response setFixVersion(final SetVersionRequest setVersionRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = IssueResource.this.getUser();
                VersionService.VersionResult versionById = IssueResource.this.jiraVersionService.getVersionById(user, Long.valueOf(setVersionRequest.versionId));
                if (!versionById.isValid()) {
                    IssueResource.this.check(ServiceOutcomeImpl.from(versionById.getErrorCollection()));
                }
                List<String> issueKeys = setVersionRequest.issueKeys;
                Set<Version> versions = Collections.singleton(versionById.getVersion());
                return IssueResource.this.setFixVersion(user, issueKeys, versions);
            }
        });
    }

    @PUT
    @Path(value="fixversion/clear")
    public Response clearFixVersion(final SetVersionRequest setVersionRequest) {
        return this.response(new Callable<Response>(){

            @Override
            public Response call() throws Exception {
                ApplicationUser user = IssueResource.this.getUser();
                List<String> issueKeys = setVersionRequest.issueKeys;
                return IssueResource.this.setFixVersion(user, issueKeys, Collections.emptySet());
            }
        });
    }

    @GET
    @Path(value="matchesBoard")
    public Response doIssuesMatchBoard(@QueryParam(value="issueIdsOrKeys") Set<String> issueIdsOrKeys, @QueryParam(value="rapidViewId") Long rapidViewId) {
        return this.response(() -> {
            ApplicationUser user = this.getUser();
            RapidView rapidView = this.check(this.rapidViewService.getRapidView(user, rapidViewId));
            ServiceOutcome<KanbanBacklogColumn> backlogColumnServiceOutcome = this.columnService.getKanbanBacklogColumn(rapidView);
            boolean kanplanEnabled = backlogColumnServiceOutcome.isValid();
            KanbanBacklogColumn backlogColumn = null;
            List<String> statusIdsInBacklog = null;
            if (kanplanEnabled) {
                backlogColumn = backlogColumnServiceOutcome.getValue();
                statusIdsInBacklog = backlogColumn.getStatusIds();
            }
            MatchesBoardResponse result = new MatchesBoardResponse();
            for (String issueIdOrKey : issueIdsOrKeys) {
                String id;
                Query query;
                Issue issue = this.check(this.issueHelper.findIssue(issueIdOrKey));
                Set<Query> match = this.check(this.searchService.findQueriesMatchingIssue(user, (Map<Issue, Collection<Query>>)ImmutableMap.of((Object)issue, (Object)ImmutableSet.of((Object)(query = this.check(this.rapidViewQueryService.getMappedRapidViewQuery(user, rapidView)))))));
                if (match.isEmpty()) continue;
                result.issueIdsOrKeys.add(issueIdOrKey);
                if (!kanplanEnabled || !statusIdsInBacklog.contains(id = issue.getStatus().getId())) continue;
                result.issuesInBacklog.add(issueIdOrKey);
            }
            return this.createOkResponse(result);
        });
    }

    private Response setFixVersion(ApplicationUser user, List<String> issueKeys, Collection<Version> versions) {
        if (issueKeys.isEmpty()) {
            this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.error.issues.issuekeys.required", new Object[0]));
        }
        Set<Object> issues = this.check(this.issueHelper.findIssuesSet(issueKeys));
        for (Issue issue2 : issues) {
            if (this.issueService.isEditable(issue2, user)) continue;
            this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.FORBIDDEN, "gh.error.issues.noteditableornotpermitted", new Object[0]));
        }
        Set versionsProjectIds = versions.stream().map(Version::getProjectId).collect(Collectors.toSet());
        if (versionsProjectIds.isEmpty()) {
            for (Issue issue3 : issues) {
                this.checkResult(this.versionService.clearIssueVersions(user, issue3));
            }
            return this.createNoContentResponse();
        }
        issues = issues.stream().filter(issue -> versionsProjectIds.contains(issue.getProjectId())).collect(Collectors.toSet());
        if (!issueKeys.isEmpty() && issues.isEmpty()) {
            this.check(ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.version.issues.project.mismatch", issues.size()));
        }
        for (Issue issue4 : issues) {
            this.check(this.versionService.setFixVersions(user, issue4, versions));
        }
        return this.createNoContentResponse();
    }

    static class UpdateFieldRequest {
        public String issueIdOrKey;
        public String fieldId;
        public String newValue;

        UpdateFieldRequest() {
        }
    }

    @XmlRootElement
    public static class MatchesBoardResponse
    extends RestTemplate {
        @XmlElement
        public Collection<String> issueIdsOrKeys = Sets.newHashSet();
        @XmlElement
        public Collection<String> issuesInBacklog = Sets.newHashSet();
    }

    @XmlRootElement
    public static class SetVersionRequest
    extends RestTemplate {
        @XmlElement
        long versionId;
        @XmlElement
        List<String> issueKeys;
    }
}

