/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.web.CurrentRequestGetter;
import com.atlassian.greenhopper.web.rapid.issue.IssueOperation;
import com.atlassian.greenhopper.web.rapid.issue.IssueOperationsModel;
import com.atlassian.greenhopper.web.rapid.issue.IssueOperationsSection;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.util.IssueOperationsBarUtil;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkSection;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueOperationsHelper {
    @Autowired
    private JiraAuthenticationContext jiraAuthenticationContext;
    @Autowired
    private CurrentRequestGetter currentRequestGetter;
    @Autowired
    private SimpleLinkManager simpleLinkManager;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private VelocityRequestContextFactory velocityRequestContextFactory;
    @Autowired
    private IssueService issueService;
    @Autowired
    private ApplicationProperties applicationProperties;
    @Autowired
    private IssueManager issueManager;
    @Autowired
    private I18nHelper.BeanFactory i18nHelperFactory;
    @Autowired
    private PermissionManager permissionManager;

    public IssueOperationsModel buildOperationsModel(ApplicationUser user, Issue issue) {
        HttpServletRequest request = this.currentRequestGetter.getCurrentRequest();
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        IssueOperationsModel model = new IssueOperationsModel();
        model.issueKey = issue.getKey();
        Map params = MapBuilder.newBuilder().add((Object)"issueId", (Object)issue.getId()).add((Object)"issue", (Object)issue).add((Object)"display-context", (Object)"view-issue").toMap();
        JiraHelper jiraHelper = new JiraHelper(request, issue.getProjectObject(), params);
        IssueOperationsBarUtil util = new IssueOperationsBarUtil(jiraHelper, user, this.simpleLinkManager, this.applicationProperties, this.issueManager, this.permissionManager, this.i18nHelperFactory.getInstance(user));
        boolean canEdit = this.issueService.isEditable(issue, user);
        if (canEdit) {
            IssueOperation edit = new IssueOperation();
            edit.id = "editIssue";
            edit.title = i18n.getText("admin.issue.operations.plugin.edit.issue.name");
            edit.styleClass = "issueaction-edit-issue";
            edit.url = String.format("%s/secure/EditIssue!default.jspa?id=%d", this.getBaseUrl(), issue.getId());
            edit.label = i18n.getText("gh.rapid.detail.edit");
            IssueOperationsSection editSection = new IssueOperationsSection();
            editSection.groupId = "issueaction-edit-issue";
            model.sections.add(editSection);
            editSection.operations.add(edit);
        }
        for (SimpleLinkSection group : util.getGroups()) {
            List promotedLinks = util.getPromotedLinks(group);
            if (promotedLinks.isEmpty()) continue;
            IssueOperationsSection opSectionPrimary = new IssueOperationsSection();
            opSectionPrimary.groupId = group.getId();
            for (SimpleLink link : promotedLinks) {
                IssueOperation issueOperation = this.toIssueOperation(util, link);
                opSectionPrimary.operations.add(issueOperation);
            }
            model.sections.add(opSectionPrimary);
            List moreSections = util.getNonEmptySectionsForGroup(group);
            boolean addToPrimary = moreSections.size() == 1;
            for (SimpleLinkSection section : moreSections) {
                List nonPromotedLinksForSection = util.getNonPromotedLinksForSection(group, section);
                if (nonPromotedLinksForSection.isEmpty()) continue;
                IssueOperationsSection opSection = new IssueOperationsSection();
                opSection.groupId = group.getId();
                for (SimpleLink link : nonPromotedLinksForSection) {
                    IssueOperation issueOperation = this.toIssueOperation(util, link);
                    if (addToPrimary) {
                        opSectionPrimary.operations.add(issueOperation);
                        continue;
                    }
                    opSection.operations.add(issueOperation);
                }
                if (addToPrimary) continue;
                model.sections.add(opSection);
            }
        }
        return model;
    }

    private String getBaseUrl() {
        return this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
    }

    private IssueOperation toIssueOperation(IssueOperationsBarUtil util, SimpleLink link) {
        IssueOperation operation = new IssueOperation();
        operation.id = link.getId();
        operation.label = util.getLabelForLink(link);
        operation.title = util.getTitleForLink(link);
        operation.styleClass = link.getStyleClass();
        operation.url = link.getUrl();
        return operation;
    }

    public Collection<SimpleLink> getIssueOperations() {
        HttpServletRequest request = this.currentRequestGetter.getCurrentRequest();
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        ArrayList<SimpleLink> links = new ArrayList<SimpleLink>();
        Map params = MapBuilder.newBuilder().add((Object)"issueId", (Object)"{0}").toMap();
        JiraHelper helper = new JiraHelper(request, null, params);
        List sections = this.simpleLinkManager.getSectionsForLocation("opsbar-operations", user, helper);
        for (SimpleLinkSection section : sections) {
            links.addAll(this.simpleLinkManager.getLinksForSectionIgnoreConditions(section.getId(), user, helper));
        }
        return links;
    }
}

