/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue;

import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.IssueFinder;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueHelper {
    @Autowired
    private IssueFinder issueFinder;

    public ServiceOutcome<Issue> findIssue(String idOrKey) {
        SimpleErrorCollection errors = new SimpleErrorCollection();
        Issue issue = this.issueFinder.findIssue(idOrKey, (ErrorCollection)errors);
        if (issue == null || errors.hasAnyErrors()) {
            return ServiceOutcomeImpl.from((ErrorCollection)errors);
        }
        return ServiceOutcomeImpl.ok(issue);
    }

    public ServiceOutcome<Issue> findIssue(long id) {
        return this.findIssue("" + id);
    }

    public ServiceOutcome<? extends List<Issue>> findIssuesList(Collection<String> idOrKeys) {
        return this.findIssues(idOrKeys, Lists.newArrayList());
    }

    public ServiceOutcome<? extends Set<Issue>> findIssuesSet(Collection<String> idOrKeys) {
        return this.findIssues(idOrKeys, Sets.newHashSet());
    }

    public ServiceOutcome<? extends Set<Issue>> findIssuesIdsSet(Collection<Long> ids) {
        return this.findIssues(ids, Sets.newHashSet());
    }

    private <T extends Collection<Issue>> ServiceOutcome<T> findIssues(Collection<?> idOrKeys, T target) {
        for (Object idOrKey : idOrKeys) {
            String idOrKeyStr = String.valueOf(idOrKey);
            ServiceOutcome<Issue> issueOutcome = this.findIssue(idOrKeyStr);
            if (issueOutcome.isInvalid()) {
                return ServiceOutcomeImpl.error(issueOutcome);
            }
            target.add((Issue)issueOutcome.getValue());
        }
        return ServiceOutcomeImpl.ok(target);
    }
}

