/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue;

import com.atlassian.greenhopper.customfield.CustomFieldService;
import com.atlassian.greenhopper.customfield.epiccolor.EpicColorCFType;
import com.atlassian.greenhopper.customfield.epiclabel.EpicLabelCFType;
import com.atlassian.greenhopper.customfield.epiclink.EpicLinkCFType;
import com.atlassian.greenhopper.customfield.epicstatus.EpicStatusCFType;
import com.atlassian.greenhopper.features.AgileDarkFeatureChecker;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.StatisticsField;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.issue.IssueTypeService;
import com.atlassian.greenhopper.service.issue.SearchService;
import com.atlassian.greenhopper.service.issue.flagging.FlagService;
import com.atlassian.greenhopper.service.issuelink.EpicCustomFieldService;
import com.atlassian.greenhopper.service.rapid.RapidViewQueryService;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorPalette;
import com.atlassian.greenhopper.service.rapid.view.color.CardColorQueryService;
import com.atlassian.greenhopper.service.rapid.view.detailview.DetailViewFieldService;
import com.atlassian.greenhopper.service.rapid.view.statistics.EstimateStatisticService;
import com.atlassian.greenhopper.service.rapid.view.statistics.TrackingStatisticService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.timetracking.TimeTrackingService;
import com.atlassian.greenhopper.service.user.GHAvatarService;
import com.atlassian.greenhopper.web.rapid.issue.CommentModelFactory;
import com.atlassian.greenhopper.web.rapid.issue.IssueEntry;
import com.atlassian.greenhopper.web.rapid.issue.IssueOperationsHelper;
import com.atlassian.greenhopper.web.rapid.issue.StatisticFieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.StatusEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.SubtaskEntry;
import com.atlassian.greenhopper.web.rapid.issue.SubtaskEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.attachment.AttachmentsFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.AffectedVersionsFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.AggregateRemainingEstimateFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.AssigneeFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.ComplexEditableFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.ComponentsFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.CreatedDateFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.DefaultCustomFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.DescriptionFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.EpicLinkFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.EpicStatusFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldUpdatedEntry;
import com.atlassian.greenhopper.web.rapid.issue.fields.FixForVersionsFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.IssueKeyFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.IssueLinksSystemFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.LabelsCustomFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.LabelsFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.NumberCustomFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.OriginalEstimateFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.RemainingEstimateFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.ReporterFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.ResolutionDateFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.SimpleEditableFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.StatusFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.SubTaskAwareFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.SubTasksRemainingEstimateFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.SummaryFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.SystemFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.TextCustomFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.UpdatedDateFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.VersionCustomFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.VotesFieldEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.issuelink.IssueLinkModelFactory;
import com.atlassian.greenhopper.web.rapid.issue.tabs.TabModelFactoryFactory;
import com.atlassian.greenhopper.web.rapid.sprint.SprintBaseEntry;
import com.atlassian.greenhopper.web.rapid.sprint.SprintEntryFactory;
import com.atlassian.greenhopper.web.util.WebUtilities;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.impl.LabelsCFType;
import com.atlassian.jira.issue.customfields.impl.NumberCFType;
import com.atlassian.jira.issue.customfields.impl.RenderableTextCFType;
import com.atlassian.jira.issue.customfields.impl.VersionCFType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.IssueLinksSystemField;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.OriginalEstimateSystemField;
import com.atlassian.jira.issue.fields.ResolutionDateSystemField;
import com.atlassian.jira.issue.fields.TimeEstimateSystemField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.bean.TimeTrackingGraphBeanFactory;
import com.atlassian.query.Query;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IssueEntryFactory {
    @Autowired
    private IssueService issueService;
    @Autowired
    private I18nFactoryService i18nFactoryService;
    @Autowired
    private CommentModelFactory commentModelFactory;
    @Autowired
    private IssueOperationsHelper issueOperationsHelper;
    @Autowired
    private CustomFieldService customFieldService;
    @Autowired
    private TabModelFactoryFactory tabModelFactoryFactory;
    @Autowired
    private UserFormats userFormats;
    @Autowired
    private TimeTrackingGraphBeanFactory timeTrackingGraphBeanFactory;
    @Autowired
    private I18nHelper.BeanFactory i18nHelperFactory;
    @Autowired
    private TimeTrackingService timeTrackingService;
    @Autowired
    public FieldHelper fieldHelper;
    @Autowired
    private WebUtilities webUtilities;
    @Autowired
    private AttachmentsFactory attachmentsFactory;
    @Autowired
    private RapidViewQueryService rapidViewQueryService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private SubtaskEntryFactory subtaskEntryFactory;
    @Autowired
    private GHAvatarService avatarService;
    @Autowired
    private StatisticFieldHelper statisticFieldHelper;
    @Autowired
    private EstimateStatisticService estimateStatisticService;
    @Autowired
    private IssueTypeSchemeManager issueTypeSchemeManager;
    @Autowired
    private TrackingStatisticService trackingStatisticService;
    @Autowired
    private AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory;
    @Autowired
    private IssueLinkModelFactory issueLinkModelFactory;
    @Autowired
    private CardColorQueryService cardColorQueryService;
    @Autowired
    private CardColorPalette cardColorPalette;
    @Autowired
    private SprintEntryFactory sprintEntryFactory;
    @Autowired
    private DetailViewFieldService fieldService;
    @Autowired
    private EpicCustomFieldService epicCustomFieldService;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private IssueTypeService issueTypeService;
    @Autowired
    private FlagService flagService;
    @Autowired
    private StatusEntryFactory statusEntryFactory;
    @Autowired
    private AgileDarkFeatureChecker agileDarkFeatureChecker;
    private Map<String, FieldEntryFactory> fieldEntryFactoriesById;
    private OriginalEstimateFieldEntryFactory originalEstimateFieldEntryFactory;
    private RemainingEstimateFieldEntryFactory remainingEstimateFieldEntryFactory;
    private static final List<String> BASE_FIELD_IDS = new ArrayList<String>();

    @PostConstruct
    public void onSpringContextStarted() {
        ArrayList<FieldEntryFactory> fieldEntryFactoryList = new ArrayList<FieldEntryFactory>();
        fieldEntryFactoryList.add(new IssueKeyFieldEntryFactory());
        fieldEntryFactoryList.add(new SummaryFieldEntryFactory());
        fieldEntryFactoryList.add(new DescriptionFieldEntryFactory(this.fieldHelper));
        fieldEntryFactoryList.add(new ReporterFieldEntryFactory(this.userFormats, this.fieldHelper));
        fieldEntryFactoryList.add(new AssigneeFieldEntryFactory(this.userFormats, this.fieldHelper));
        fieldEntryFactoryList.add(new CreatedDateFieldEntryFactory(this.fieldHelper));
        fieldEntryFactoryList.add(new UpdatedDateFieldEntryFactory(this.fieldHelper));
        fieldEntryFactoryList.add(new StatusFieldEntryFactory(this.fieldHelper, this.statusEntryFactory));
        fieldEntryFactoryList.add(new ComponentsFieldEntryFactory(this.fieldHelper));
        fieldEntryFactoryList.add(new LabelsFieldEntryFactory(this.fieldHelper));
        fieldEntryFactoryList.add(new AffectedVersionsFieldEntryFactory(this.fieldHelper));
        fieldEntryFactoryList.add(new FixForVersionsFieldEntryFactory(this.fieldHelper));
        fieldEntryFactoryList.add(new VotesFieldEntryFactory(this.fieldHelper));
        this.fieldEntryFactoriesById = new LinkedHashMap<String, FieldEntryFactory>();
        for (FieldEntryFactory fieldEntryFactory : fieldEntryFactoryList) {
            this.fieldEntryFactoriesById.put(fieldEntryFactory.getId(), fieldEntryFactory);
        }
        this.originalEstimateFieldEntryFactory = new OriginalEstimateFieldEntryFactory(this.i18nHelperFactory, this.timeTrackingGraphBeanFactory, this.timeTrackingService, this.fieldHelper);
        this.remainingEstimateFieldEntryFactory = new RemainingEstimateFieldEntryFactory(this.i18nHelperFactory, this.timeTrackingGraphBeanFactory, this.timeTrackingService, this.fieldHelper);
    }

    public MutableIssue getIssue(ApplicationUser user, Long issueId, ErrorCollection errorCollection) {
        IssueService.IssueResult result = this.issueService.getIssue(user, issueId);
        if (result.getErrorCollection().hasAnyErrors()) {
            errorCollection.addAllErrors(ErrorCollection.fromJiraErrorCollection(result.getErrorCollection()));
        }
        MutableIssue issue = result.getIssue();
        return issue;
    }

    public MutableIssue getIssue(ApplicationUser user, String issueKey, ErrorCollection errorCollection) {
        IssueService.IssueResult result = this.issueService.getIssue(user, issueKey);
        if (result.getErrorCollection().hasAnyErrors()) {
            errorCollection.addAllErrors(ErrorCollection.fromJiraErrorCollection(result.getErrorCollection()));
        }
        MutableIssue issue = result.getIssue();
        return issue;
    }

    public ServiceOutcome<IssueEntry> buildViewEntry(ApplicationUser user, RapidView rapidView, Issue issue, StatisticsField estimateStatistic, StatisticsField trackingStatistic, boolean loadSubtasks, Option<Sprint> activeFutureSprint) {
        IssueEntry entry = this.createBaseEntry(user, issue, estimateStatistic, trackingStatistic);
        ServiceOutcome<List<? extends Field>> configuredFieldsOutcome = this.fieldService.getDetailViewFields(rapidView);
        if (!configuredFieldsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(configuredFieldsOutcome);
        }
        boolean bl = entry.isSubtask = issue.getParentId() != null;
        if (Objects.nonNull(issue.getParentObject())) {
            entry.parentKey = issue.getParentObject().getKey();
        }
        entry.operations = this.issueOperationsHelper.buildOperationsModel(user, issue);
        Project project = issue.getProjectObject();
        entry.projectName = project.getName();
        entry.projectAvatarUrl = this.avatarService.getLargeProjectAvatarURL(project);
        boolean bl2 = entry.isAssigned = issue.getAssigneeId() != null;
        if (activeFutureSprint.isDefined()) {
            entry.sprint = (SprintBaseEntry)this.sprintEntryFactory.newBaseTransformer(user).apply(activeFutureSprint.get());
        }
        entry.tabs = this.tabModelFactoryFactory.newFactory().createModel(rapidView, issue, configuredFieldsOutcome.getValue(), estimateStatistic, trackingStatistic);
        entry.flagged = this.flagService.isFlagged(issue);
        return ServiceOutcomeImpl.ok(entry);
    }

    public IssueEntry buildEditEntry(ApplicationUser user, Issue issue, StatisticsField estimateStatistic, StatisticsField trackingStatistic, boolean issueInOpenSprint) {
        IssueEntry entry = this.createBaseEntry(user, issue, estimateStatistic, trackingStatistic);
        Collection<Issue> subTasks = null;
        entry.fields = this.getEditFields(user, issue, subTasks, estimateStatistic, trackingStatistic, issueInOpenSprint);
        return entry;
    }

    private ServiceOutcome<Pair<List<Issue>, Long>> getSubTasks(ApplicationUser user, RapidView rapidView, Issue issue) {
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder().where().issueParent().eq(issue.getId()).endWhere();
        ServiceOutcome<Long> totalCount = this.searchService.searchCount(user, builder.buildQuery());
        if (!totalCount.isValid()) {
            return ServiceOutcomeImpl.error(totalCount);
        }
        if (totalCount.get().equals(0L)) {
            return ServiceOutcomeImpl.ok(Pair.of(Collections.emptyList(), (Object)totalCount.get()));
        }
        ServiceOutcome<Query> rapidViewQuery = this.rapidViewQueryService.getMappedRapidViewQuery(user, rapidView);
        if (!rapidViewQuery.isValid()) {
            return ServiceOutcomeImpl.error(rapidViewQuery);
        }
        builder = JqlQueryBuilder.newBuilder((Query)rapidViewQuery.getValue()).where().defaultAnd().issueParent().eq(issue.getId()).endWhere();
        ServiceOutcome<SearchResults<Issue>> search = this.searchService.search(user, builder.buildQuery());
        if (!search.isValid()) {
            return ServiceOutcomeImpl.error(search);
        }
        return ServiceOutcomeImpl.ok(Pair.of((Object)search.getValue().getResults(), (Object)totalCount.getValue()));
    }

    private List<SubtaskEntry> convertSubTasksToEntries(ApplicationUser user, List<Issue> subTasks, StatisticsField trackingStatistic) {
        ArrayList<SubtaskEntry> entries = new ArrayList<SubtaskEntry>();
        for (Issue subtask : subTasks) {
            SubtaskEntry subtaskEntry = this.subtaskEntryFactory.createSubtaskEntry(user, subtask, trackingStatistic);
            entries.add(subtaskEntry);
        }
        return entries;
    }

    public ServiceOutcome<FieldUpdatedEntry> updateField(ApplicationUser user, Issue issue, String fieldId, String newValue) {
        ServiceOutcome<Void> updateOutcome;
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ErrorCollection errorCollection = new ErrorCollection();
        ServiceOutcome<FieldEntryFactory> fieldOutcome = this.getFieldForId(fieldId);
        if (!fieldOutcome.isValid()) {
            return ServiceOutcomeImpl.error(fieldOutcome);
        }
        FieldEntryFactory fieldEntryFactory = fieldOutcome.getValue();
        if (fieldEntryFactory instanceof SubTaskAwareFieldEntryFactory) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "gh.rapid.detail.view.update.field.not.editable", fieldEntryFactory.getId());
        }
        if (fieldEntryFactory instanceof ComplexEditableFieldEntryFactory ? !(updateOutcome = ((ComplexEditableFieldEntryFactory)fieldEntryFactory).updateField(user, issue, newValue)).isValid() : fieldEntryFactory instanceof SimpleEditableFieldEntryFactory && !(updateOutcome = this.fieldHelper.updateField(user, issue, (SimpleEditableFieldEntryFactory)fieldEntryFactory, newValue)).isValid()) {
            return ServiceOutcomeImpl.error(updateOutcome);
        }
        issue = this.getIssue(user, issue.getId(), errorCollection);
        if (errorCollection.hasErrors()) {
            return ServiceOutcomeImpl.from(errorCollection);
        }
        FieldEntry view = fieldEntryFactory.createViewEntry(i18n, issue, user);
        FieldEntry edit = fieldEntryFactory.createEditEntry(i18n, issue, user);
        FieldUpdatedEntry success = new FieldUpdatedEntry();
        success.view = view;
        success.edit = edit;
        success.issueId = issue.getId();
        return ServiceOutcomeImpl.ok(success);
    }

    private ServiceOutcome<FieldEntryFactory> getFieldForId(String id) {
        if (this.fieldEntryFactoriesById.containsKey(id)) {
            return ServiceOutcomeImpl.ok(this.fieldEntryFactoriesById.get(id));
        }
        if ("timeoriginalestimate".equals(id)) {
            return ServiceOutcomeImpl.ok(this.originalEstimateFieldEntryFactory);
        }
        if ("timeestimate".equals(id)) {
            return ServiceOutcomeImpl.ok(this.remainingEstimateFieldEntryFactory);
        }
        CustomField customField = this.customFieldService.getCustomField(id);
        if (customField != null) {
            if (customField.getCustomFieldType() instanceof EpicStatusCFType) {
                return ServiceOutcomeImpl.ok(new EpicStatusFieldEntryFactory(customField, this.fieldHelper));
            }
            if (customField.getCustomFieldType() instanceof NumberCFType) {
                return ServiceOutcomeImpl.ok(new NumberCustomFieldEntryFactory(customField, this.fieldHelper));
            }
            if (customField.getCustomFieldType() instanceof RenderableTextCFType) {
                return ServiceOutcomeImpl.ok(new TextCustomFieldEntryFactory(customField, this.fieldHelper));
            }
            if (customField.getCustomFieldType() instanceof EpicLabelCFType) {
                return ServiceOutcomeImpl.ok(new TextCustomFieldEntryFactory(customField, this.fieldHelper));
            }
            if (customField.getCustomFieldType() instanceof EpicColorCFType) {
                return ServiceOutcomeImpl.ok(new TextCustomFieldEntryFactory(customField, this.fieldHelper));
            }
        }
        return ServiceOutcomeImpl.error(ErrorCollection.Reason.VALIDATION_FAILED, "unknown.field", new Object[0]);
    }

    private IssueEntry createBaseEntry(ApplicationUser user, Issue issue, StatisticsField estimateStatistic, StatisticsField trackingStatistic) {
        IssueEntry entry = new IssueEntry();
        entry.id = issue.getId();
        entry.key = issue.getKey();
        entry.editable = this.issueService.isEditable(issue, user);
        entry.primaryStatisticFieldId = this.statisticFieldHelper.getEstimateStatisticFieldId(estimateStatistic, issue);
        entry.trackingStatisticFieldId = this.statisticFieldHelper.getTrackingStatisticFieldId(trackingStatistic, issue);
        return entry;
    }

    private List<FieldEntry> getViewFields(ApplicationUser user, Issue issue, Collection<? extends Field> configuredFields, Collection<Issue> subTasks, StatisticsField estimateStatistic, StatisticsField trackingStatistic, boolean issueInActiveSprint) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ArrayList<FieldEntry> fieldEntries = new ArrayList<FieldEntry>();
        for (String string : BASE_FIELD_IDS) {
            FieldEntry entry;
            FieldEntryFactory fieldEntryFactory = this.fieldEntryFactoriesById.get(string);
            if (!fieldEntryFactory.isFieldValid(issue) || (entry = fieldEntryFactory.createViewEntry(i18n, issue, user)) == null) continue;
            fieldEntries.add(entry);
        }
        for (Field field : configuredFields) {
            FieldEntryFactory entryFactory = this.getFieldEntryFactory(field);
            if (!entryFactory.isFieldValid(issue) || field.equals(estimateStatistic.getField())) continue;
            fieldEntries.add(entryFactory.createViewEntry(i18n, issue, user));
        }
        this.addEstimateStatisticField(user, i18n, issue, fieldEntries, estimateStatistic);
        this.addTrackingStatisticField(user, i18n, issue, subTasks, fieldEntries, trackingStatistic, issueInActiveSprint, true);
        return fieldEntries;
    }

    public FieldEntryFactory getFieldEntryFactory(Field configuredField) {
        FieldEntryFactory factoryByFieldId = this.fieldEntryFactoriesById.get(configuredField.getId());
        if (factoryByFieldId != null) {
            return factoryByFieldId;
        }
        if (configuredField instanceof CustomField) {
            CustomField customField = (CustomField)configuredField;
            if (customField.getCustomFieldType() instanceof LabelsCFType) {
                return new LabelsCustomFieldEntryFactory(this.fieldHelper, customField);
            }
            if (customField.getCustomFieldType() instanceof VersionCFType) {
                return new VersionCustomFieldEntryFactory(this.fieldHelper, customField);
            }
            if (customField.getCustomFieldType() instanceof EpicLinkCFType) {
                return new EpicLinkFieldEntryFactory(this.fieldHelper, customField, this.epicCustomFieldService, this.permissionService, this.issueTypeService);
            }
            return new DefaultCustomFieldEntryFactory(this.fieldHelper, customField);
        }
        if (configuredField instanceof IssueLinksSystemField) {
            return new IssueLinksSystemFieldEntryFactory(this.fieldHelper, (OrderableField)((IssueLinksSystemField)configuredField));
        }
        if (configuredField instanceof OrderableField) {
            return new SystemFieldEntryFactory(this.fieldHelper, (OrderableField)configuredField);
        }
        if (configuredField instanceof ResolutionDateSystemField) {
            return new ResolutionDateFieldEntryFactory(this.fieldHelper, (ResolutionDateSystemField)configuredField);
        }
        return null;
    }

    private List<FieldEntry> getEditFields(ApplicationUser user, Issue issue, Collection<Issue> subTasks, StatisticsField estimateStatistic, StatisticsField trackingStatistic, boolean issueInOpenSprint) {
        I18n2 i18n = this.i18nFactoryService.getI18n(user);
        ArrayList<FieldEntry> fieldEntries = new ArrayList<FieldEntry>();
        for (FieldEntryFactory fieldEntryFactory : this.fieldEntryFactoriesById.values()) {
            FieldEntry entry = fieldEntryFactory.createEditEntry(i18n, issue, user);
            if (entry == null) continue;
            fieldEntries.add(entry);
        }
        this.addEstimateStatisticField(user, i18n, issue, fieldEntries, estimateStatistic);
        this.addTrackingStatisticField(user, i18n, issue, subTasks, fieldEntries, trackingStatistic, issueInOpenSprint, false);
        return fieldEntries;
    }

    private void addEstimateStatisticField(ApplicationUser user, I18n2 i18n, Issue issue, List<FieldEntry> fields, StatisticsField estimateStatistic) {
        if (!this.estimateStatisticService.isEstimateStatisticValidAndEnabled(estimateStatistic)) {
            return;
        }
        if (!estimateStatistic.isFieldBased()) {
            return;
        }
        if (this.estimateStatisticService.isEstimateStatisticFieldAndNotApplicable(estimateStatistic, issue)) {
            return;
        }
        Field jiraField = estimateStatistic.getField();
        FieldEntry viewEntry = null;
        if (jiraField instanceof CustomField) {
            CustomField statisticField = (CustomField)jiraField;
            NumberCustomFieldEntryFactory field = new NumberCustomFieldEntryFactory(statisticField, this.fieldHelper);
            viewEntry = field.createViewEntry(i18n, issue, user);
        } else if (jiraField instanceof OriginalEstimateSystemField) {
            OriginalEstimateFieldEntryFactory originalEstimateField = new OriginalEstimateFieldEntryFactory(this.i18nHelperFactory, this.timeTrackingGraphBeanFactory, this.timeTrackingService, this.fieldHelper);
            viewEntry = originalEstimateField.createViewEntry(i18n, issue, user);
        }
        if (viewEntry != null) {
            fields.add(viewEntry);
        }
    }

    private void addTrackingStatisticField(ApplicationUser user, I18n2 i18n, Issue issue, Collection<Issue> subTasks, List<FieldEntry> fields, StatisticsField trackingStatistic, boolean issueInActiveSprint, boolean isViewOnly) {
        if (!this.trackingStatisticService.isTrackingStatisticValidAndEnabled(trackingStatistic)) {
            return;
        }
        if (!trackingStatistic.isFieldBased()) {
            return;
        }
        if (this.trackingStatisticService.isTrackingStatisticFieldAndNotApplicable(trackingStatistic, issue)) {
            return;
        }
        Field jiraField = trackingStatistic.getField();
        ArrayList<FieldEntry> viewEntriesToAdd = new ArrayList<FieldEntry>();
        if (jiraField instanceof TimeEstimateSystemField) {
            RemainingEstimateFieldEntryFactory remainingEstimateField = new RemainingEstimateFieldEntryFactory(this.i18nHelperFactory, this.timeTrackingGraphBeanFactory, this.timeTrackingService, this.fieldHelper);
            FieldEntry viewEntry = remainingEstimateField.createViewEntry(i18n, issue, user);
            viewEntriesToAdd.add(viewEntry);
            viewEntry.editable = true;
            if (isViewOnly && subTasks != null && !subTasks.isEmpty()) {
                AggregateRemainingEstimateFieldEntryFactory aggregateRemainingEstimateField = new AggregateRemainingEstimateFieldEntryFactory(this.i18nHelperFactory, this.timeTrackingGraphBeanFactory, this.aggregateTimeTrackingCalculatorFactory, this.timeTrackingService, null);
                viewEntriesToAdd.add(aggregateRemainingEstimateField.createViewEntry(i18n, issue, subTasks, user));
                SubTasksRemainingEstimateFieldEntryFactory subTasksRemainingEstimateField = new SubTasksRemainingEstimateFieldEntryFactory(this.i18nHelperFactory, this.timeTrackingGraphBeanFactory, this.aggregateTimeTrackingCalculatorFactory, this.timeTrackingService, null);
                viewEntriesToAdd.add(subTasksRemainingEstimateField.createViewEntry(i18n, issue, subTasks, user));
            }
        }
        if (!viewEntriesToAdd.isEmpty()) {
            fields.addAll(viewEntriesToAdd);
        }
    }

    static {
        BASE_FIELD_IDS.add("issuekey");
        BASE_FIELD_IDS.add("summary");
        BASE_FIELD_IDS.add("description");
    }
}

