/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.issue;

import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.user.GHAvatarService;
import com.atlassian.greenhopper.web.rapid.issue.CommentEntry;
import com.atlassian.greenhopper.web.rapid.issue.IssueEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.fields.FieldHelper;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRole;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommentModelFactory {
    @Autowired
    private CommentService commentService;
    @Autowired
    private JiraAuthenticationContext authContext;
    @Autowired
    private IssueEntryFactory issueEntryFactory;
    @Autowired
    private GHAvatarService avatarService;
    @Autowired
    private DateTimeFormatterFactory dateTimeFormatterFactory;
    @Autowired
    private FieldHelper fieldHelper;
    @Autowired
    private I18nFactoryService i18nFactoryService;

    public List<CommentEntry> getAllComments(ApplicationUser user, Issue issue) {
        ArrayList<CommentEntry> commentEntries = new ArrayList<CommentEntry>();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        List comments = this.commentService.getCommentsForUser(user, issue, (ErrorCollection)errorCollection);
        if (comments.size() > 0) {
            for (int i = comments.size() - 1; i >= 0; --i) {
                Comment comment = (Comment)comments.get(i);
                CommentEntry entry = this.newCommentEntryFrom(comment, issue);
                commentEntries.add(entry);
            }
        }
        return commentEntries;
    }

    private CommentEntry newCommentEntryFrom(Comment comment, Issue issue) {
        CommentEntry entry = new CommentEntry();
        entry.id = comment.getId();
        entry.html = this.fieldHelper.getRenderedText(issue, "comment", comment.getBody());
        ApplicationUser author = comment.getAuthorApplicationUser();
        if (author != null) {
            entry.author = author.getName();
            entry.authorName = author.getDisplayName();
            entry.avatarUrl = this.avatarService.getSmallAvatarURL(author);
        } else {
            I18n2 i18n = this.i18nFactoryService.getI18n(this.authContext.getUser());
            entry.author = null;
            entry.authorName = i18n.getText("common.words.anonymous");
            entry.avatarUrl = this.avatarService.getSmallAvatarURL(null);
        }
        entry.restrictedTo = null;
        ProjectRole role = comment.getRoleLevel();
        if (role != null) {
            entry.restrictedTo = role.getName();
        } else if (comment.getGroupLevel() != null) {
            entry.restrictedTo = comment.getGroupLevel();
        }
        Date createdDate = comment.getCreated();
        DateTimeFormatter formatter = this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.ISO_8601_DATE_TIME).forLoggedInUser();
        entry.dateTime = formatter.format(createdDate);
        formatter = this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.COMPLETE).forLoggedInUser();
        entry.dateTimeDisplay = formatter.format(createdDate);
        return entry;
    }
}

