/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.event;

import com.atlassian.analytics.api.annotations.EventName;
import java.util.HashMap;
import java.util.Map;

@EventName(value="gh.rapidboard.unlicensed")
public class UnlicensedAnalyticsEvent {
    private static final Map<String, Chart> requestNameToChart = new HashMap<String, Chart>();
    private final Page requestedPage;
    private final Chart requestedChart;

    public UnlicensedAnalyticsEvent(Page requestedPage) {
        this.requestedPage = requestedPage;
        this.requestedChart = null;
    }

    public UnlicensedAnalyticsEvent(Page requestedPage, Chart chart) {
        this.requestedPage = requestedPage;
        this.requestedChart = chart;
    }

    public String getPage() {
        return this.requestedPage.pageName;
    }

    public String getChart() {
        return this.requestedChart == null ? null : this.requestedChart.analyticName;
    }

    static {
        for (Chart c : Chart.values()) {
            requestNameToChart.put(c.requestedChartName, c);
        }
    }

    public static enum Chart {
        BURNDOWN_CHART("burndownchart", "burndownChart"),
        SPRINT_RETROSPECTIVE("sprintretrospective", "sprintRetrospective"),
        VELOCITY_CHART("velocitychart", "velocityChart"),
        CUMULATIVE_FLOW_DIAGRAM("cumulativeflowdiagram", "cumulativeFlowDiagram"),
        VERSION_REPORT("versionreport", "versionReport"),
        EPIC_REPORT("epicreport", "epicReport"),
        CONTROL_CHART("controlchart", "controlChart"),
        EPIC_BURNDOWN("epicburndown", "epicBurndown"),
        RELEASE_BURNDOWN("releaseburndown", "releaseBurndown"),
        UNKNOWN("", "");

        private final String analyticName;
        private final String requestedChartName;

        private Chart(String analyticName, String requestedChartName) {
            this.analyticName = analyticName;
            this.requestedChartName = requestedChartName;
        }

        public static Chart getForRequestParameter(String chartParameter) {
            Chart c = (Chart)((Object)requestNameToChart.get(chartParameter));
            return c != null ? c : UNKNOWN;
        }
    }

    public static enum Page {
        RAPID_BOARD("showboard"),
        MANAGE_RAPID_VIEWS("manageboards"),
        RAPID_VIEW("configureboard"),
        REPORT("report");

        private final String pageName;

        private Page(String pageName) {
            this.pageName = pageName;
        }
    }
}

