/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.epics;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.PermissionService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.rapid.entity.epic.EpicLinkedPagesModelFactory;
import com.atlassian.greenhopper.web.rapid.epics.EpicData;
import com.atlassian.greenhopper.web.rapid.list.ClassificationStatistics;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.greenhopper.web.rapid.plan.ClassificationStatisticService;
import com.atlassian.greenhopper.web.rapid.project.ProjectEntry;
import com.atlassian.greenhopper.web.rapid.project.ProjectEntryTransformer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EpicsHelper {
    @Autowired
    private RapidIssueEntryQueryService rapidIssueEntryQueryService;
    @Autowired
    private ProjectEntryTransformer projectEntryTransformer;
    @Autowired
    private PermissionService permissionService;
    @Autowired
    private ClassificationStatisticService classificationStatisticService;
    @Autowired
    private EpicLinkedPagesModelFactory epicLinkedPagesModelFactory;

    public ServiceOutcome<EpicData> loadEpicData(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<CollectIssuesResult> epicIssuesResult = this.rapidIssueEntryQueryService.collectEpicIssues(user, rapidView);
        if (!epicIssuesResult.isValid()) {
            return ServiceOutcomeImpl.error(epicIssuesResult);
        }
        List<RapidIssueEntry> epics = epicIssuesResult.getValue().getIssues();
        ServiceOutcome<Void> epicStatsOutcome = this.loadEpicStatistics(user, rapidView, epics);
        if (!epicStatsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(epicStatsOutcome);
        }
        List<ProjectEntry> projects = epicIssuesResult.getValue().getProjects();
        boolean canEditEpics = this.canEditEpics(user, projects);
        EpicData data = new EpicData();
        data.epics = epics;
        data.canEditEpics = canEditEpics;
        data.supportsPages = this.epicLinkedPagesModelFactory.hasPagesSupport();
        return ServiceOutcomeImpl.ok(data);
    }

    private boolean canEditEpics(ApplicationUser user, List<ProjectEntry> projects) {
        ImmutableList projectsToRegister = ImmutableList.copyOf((Iterable)Iterables.transform(projects, (Function)this.projectEntryTransformer));
        boolean canEditEpics = this.permissionService.hasSomePermission(user, (Collection<Project>)projectsToRegister, 12);
        return canEditEpics;
    }

    private ServiceOutcome<Void> loadEpicStatistics(ApplicationUser user, RapidView rapidView, List<RapidIssueEntry> epics) {
        ServiceOutcome<Map<String, ClassificationStatistics>> epicStatisticsOutcome = this.classificationStatisticService.getEpicStatistics(user, rapidView);
        if (!epicStatisticsOutcome.isValid()) {
            return ServiceOutcomeImpl.error(epicStatisticsOutcome);
        }
        Map<String, ClassificationStatistics> epicStatisticsMap = epicStatisticsOutcome.getValue();
        for (RapidIssueEntry epic : epics) {
            epic.epicStats = epicStatisticsMap.get(String.valueOf(epic.id));
            if (epic.epicStats != null) continue;
            epic.epicStats = new ClassificationStatistics();
        }
        return ServiceOutcomeImpl.ok();
    }
}

