/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.entity.sprint;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.greenhopper.api.entity.remotelink.sprint.RemoteSprintLink;
import com.atlassian.greenhopper.entity.remotelink.sprint.ConfluenceRemoteSprintLinkDecoratorService;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.sprint.RemoteSprintLinkService;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.web.rapid.entity.common.AbstractLinkedPagesModelFactory;
import com.atlassian.greenhopper.web.rapid.entity.common.LinkedPagesModel;
import com.atlassian.greenhopper.web.rapid.entity.common.RemoteEntityLinkModel;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.plugin.viewissue.issuelink.GlobalIdFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SprintLinkedPagesModelFactory
extends AbstractLinkedPagesModelFactory {
    @Autowired
    private RemoteSprintLinkService remoteSprintLinkService;
    @Autowired
    private ConfluenceRemoteSprintLinkDecoratorService confluenceRemoteSprintLinkDecoratorService;
    @Autowired
    private I18nFactoryService i18nFactoryService;

    public int getCountOfLinkedPages(ApplicationUser user, Sprint sprint) {
        ServiceOutcome<List<RemoteSprintLink>> remoteSprintLinksOutcome = this.remoteSprintLinkService.getRemoteSprintLinks(user, sprint, RemoteSprintLink.ApplicationType.CONFLUENCE);
        return remoteSprintLinksOutcome.getValue().size();
    }

    public List<RemoteEntityLinkModel> getPagesForSprint(ApplicationUser user, Sprint sprint, List<LinkedPagesModel.ApplicationLinkModel> applicationLinks) {
        ServiceOutcome<List<RemoteSprintLink>> remoteSprintLinksOutcome = this.remoteSprintLinkService.getRemoteSprintLinks(user, sprint, RemoteSprintLink.ApplicationType.CONFLUENCE);
        if (remoteSprintLinksOutcome.isInvalid()) {
            return Collections.emptyList();
        }
        ArrayList remoteSprintLinks = Lists.newArrayList();
        for (RemoteSprintLink remoteSprintLink : remoteSprintLinksOutcome.getValue()) {
            remoteSprintLinks.add(this.toModel(remoteSprintLink, this.getUpdatedContext(remoteSprintLink)));
        }
        Collections.sort(remoteSprintLinks, new Comparator<RemoteEntityLinkModel>(){

            @Override
            public int compare(RemoteEntityLinkModel o1, RemoteEntityLinkModel o2) {
                return o1.id.compareTo(o2.id);
            }
        });
        return remoteSprintLinks;
    }

    public ServiceOutcome<RemoteEntityLinkModel> linkPageToSprint(ApplicationUser user, Sprint sprint, String pageId, String pageTitle) {
        ApplicationLink appLink = this.applicationLinkService.getPrimaryApplicationLink(ConfluenceApplicationType.class);
        if (appLink == null) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "gh.entity.pages.server.missing", new Object[0]);
        }
        String globalId = GlobalIdFactory.encode((List)KEYS, (Map)ImmutableMap.of((Object)"appId", (Object)appLink.getId().get(), (Object)"pageId", (Object)pageId));
        ServiceOutcome<RemoteSprintLink> remoteSprintLinkOutcome = this.remoteSprintLinkService.createRemoteSprintLink(user, sprint.getId(), globalId, "Page", this.buildPageUrl(appLink, pageId), "Wiki Page", RemoteSprintLink.ApplicationType.CONFLUENCE.getName(), appLink.getName());
        if (remoteSprintLinkOutcome.isInvalid()) {
            return ServiceOutcomeImpl.from(remoteSprintLinkOutcome.getErrors());
        }
        RemoteSprintLink remoteSprintLink = remoteSprintLinkOutcome.getValue();
        return ServiceOutcomeImpl.ok(this.toModel(remoteSprintLink, this.getUpdatedContext(remoteSprintLink)));
    }

    private Map<String, Object> getUpdatedContext(RemoteSprintLink remoteSprintLink) {
        HashMap updatedContext = Maps.newHashMap();
        I18n2 i18n = this.i18nFactoryService.getI18n();
        try {
            RemoteSprintLink updatedRemoteSprintLink = this.confluenceRemoteSprintLinkDecoratorService.decorate(remoteSprintLink);
            updatedContext.put("appLinkExists", true);
        }
        catch (CredentialsRequiredException exception) {
            URI authorisationURI = exception.getAuthorisationURI();
            if (authorisationURI == null) {
                updatedContext.put("noApplinkAuthConfigured", Boolean.TRUE);
            } else {
                ApplicationLink applicationLink = this.confluenceRemoteSprintLinkDecoratorService.getGlobalId(remoteSprintLink).getApplicationLink();
                String applicationName = (String)StringUtils.defaultIfEmpty((CharSequence)applicationLink.getName(), (CharSequence)i18n.getText("viewissue.links.types.confluencepage"));
                updatedContext.put("authenticationRequired", Boolean.TRUE);
                updatedContext.put("authenticationUrl", exception.getAuthorisationURI());
                updatedContext.put("applicationName", applicationName);
                updatedContext.put("appLinkId", applicationLink.getId());
                updatedContext.put("applicationUrl", applicationLink.getDisplayUrl());
            }
        }
        catch (PermissionException e) {
            ApplicationLink applicationLink = this.confluenceRemoteSprintLinkDecoratorService.getGlobalId(remoteSprintLink).getApplicationLink();
            String applicationName = (String)StringUtils.defaultIfEmpty((CharSequence)applicationLink.getName(), (CharSequence)i18n.getText("viewissue.links.types.confluencepage"));
            updatedContext.put("permissionDenied", Boolean.TRUE);
            updatedContext.put("applicationName", applicationName);
            updatedContext.put("applicationUrl", applicationLink.getDisplayUrl());
        }
        catch (Exception e) {
            remoteSprintLink.setTitle(i18n.getText("gh.entity.pages.failed"));
        }
        return updatedContext;
    }

    private RemoteEntityLinkModel toModel(RemoteSprintLink remoteSprintLink, Map<String, Object> updatedContext) {
        RemoteEntityLinkModel model = new RemoteEntityLinkModel(remoteSprintLink.getId(), remoteSprintLink.getSprintId(), remoteSprintLink.getTitle(), this.buildPageUrlWithSrc(remoteSprintLink.getUrl(), "sprint"));
        if (updatedContext.containsKey("pageDeleted")) {
            model.pageDeleted = true;
        }
        if (updatedContext.containsKey("appLinkExists") && updatedContext.get("appLinkExists").equals(false)) {
            model.appLinkExists = false;
        }
        if (updatedContext.containsKey("permissionDenied")) {
            model.permissionDenied = (Boolean)updatedContext.get("permissionDenied");
        }
        if (updatedContext.containsKey("serverUnavailable")) {
            model.serverUnavailable = (Boolean)updatedContext.get("serverUnavailable");
        }
        if (updatedContext.containsKey("authenticationRequired")) {
            model.authenticationRequired = (Boolean)updatedContext.get("authenticationRequired");
        }
        if (updatedContext.containsKey("authenticationUrl")) {
            model.authenticationUrl = updatedContext.get("authenticationUrl").toString();
        }
        if (updatedContext.containsKey("appLinkId")) {
            model.applicationLinkId = updatedContext.get("appLinkId").toString();
        }
        model.pageId = this.extractPageIdFromGlobalId(remoteSprintLink.getGlobalId());
        return model;
    }
}

