/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.entity.epic;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.application.confluence.ConfluenceApplicationType;
import com.atlassian.greenhopper.issue.link.RemoteIssueLinkSearchService;
import com.atlassian.greenhopper.model.I18n2;
import com.atlassian.greenhopper.service.I18nFactoryService;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.web.rapid.entity.common.AbstractLinkedPagesModelFactory;
import com.atlassian.greenhopper.web.rapid.entity.common.LinkedPagesModel;
import com.atlassian.greenhopper.web.rapid.entity.common.RemoteEntityLinkModel;
import com.atlassian.jira.bc.issue.link.RemoteIssueLinkService;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.plugin.viewissue.issuelink.GlobalIdFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EpicLinkedPagesModelFactory
extends AbstractLinkedPagesModelFactory {
    @Autowired
    private FieldVisibilityManager fieldVisibilityManager;
    @Autowired
    private RemoteIssueLinkManager remoteIssueLinkManager;
    @Autowired
    private RemoteIssueLinkService remoteIssueLinkService;
    @Autowired
    private RemoteIssueLinkSearchService remoteIssueLinkSearchService;
    @Autowired
    private I18nFactoryService i18nFactoryService;

    public List<RemoteEntityLinkModel> getPages(Issue epic, List<LinkedPagesModel.ApplicationLinkModel> applicationLinks) {
        boolean valid = this.fieldVisibilityManager.isFieldVisible("issuelinks", epic);
        if (!valid) {
            return Collections.emptyList();
        }
        List<RemoteIssueLink> remoteLinksForIssue = this.remoteIssueLinkSearchService.getRemoteLinksForIssue(epic, RemoteIssueLink.APPLICATION_TYPE_CONFLUENCE);
        ArrayList<RemoteEntityLinkModel> issueLinkModels = new ArrayList<RemoteEntityLinkModel>();
        for (RemoteIssueLink remoteIssueLink : remoteLinksForIssue) {
            Map<String, Object> updatedContext = this.getUpdatedContextWithFailSafe(remoteIssueLink);
            issueLinkModels.add(this.getModel(remoteIssueLink, updatedContext));
        }
        Collections.sort(issueLinkModels, new Comparator<RemoteEntityLinkModel>(){

            @Override
            public int compare(RemoteEntityLinkModel o1, RemoteEntityLinkModel o2) {
                return o1.id.compareTo(o2.id);
            }
        });
        return issueLinkModels;
    }

    public int getCountOfLinkedPages(Issue epic) {
        List<RemoteIssueLink> remoteLinksForIssue = this.remoteIssueLinkSearchService.getRemoteLinksForIssue(epic, RemoteIssueLink.APPLICATION_TYPE_CONFLUENCE);
        return remoteLinksForIssue.size();
    }

    public ServiceOutcome<RemoteEntityLinkModel> linkPageToEpic(ApplicationUser user, Issue epic, String pageId) {
        ApplicationLink appLink = this.applicationLinkService.getPrimaryApplicationLink(ConfluenceApplicationType.class);
        String globalId = GlobalIdFactory.encode((List)KEYS, (Map)ImmutableMap.of((Object)"appId", (Object)appLink.getId().get(), (Object)"pageId", (Object)pageId));
        RemoteIssueLinkBuilder builder = new RemoteIssueLinkBuilder();
        builder.applicationType(RemoteIssueLink.APPLICATION_TYPE_CONFLUENCE).applicationName(appLink.getName()).issueId(epic.getId()).title("Page").globalId(globalId).relationship("Wiki Page").url(this.buildPageUrl(appLink, pageId));
        RemoteIssueLinkService.CreateValidationResult validationResult = this.remoteIssueLinkService.validateCreate(user, builder.build());
        if (!validationResult.isValid()) {
            return ServiceOutcomeImpl.from(validationResult.getErrorCollection());
        }
        RemoteIssueLinkService.RemoteIssueLinkResult remoteIssueLinkResult = this.remoteIssueLinkService.create(user, validationResult);
        RemoteIssueLink remoteIssueLink = remoteIssueLinkResult.getRemoteIssueLink();
        Map<String, Object> updatedContext = this.getUpdatedContextWithFailSafe(remoteIssueLink);
        return ServiceOutcomeImpl.ok(this.getModel(remoteIssueLink, updatedContext));
    }

    private Map<String, Object> getUpdatedContextWithFailSafe(RemoteIssueLink remoteIssueLink) {
        HashMap updatedContext;
        try {
            updatedContext = this.remoteIssueLinkSearchService.getUpdatedContext(remoteIssueLink);
        }
        catch (RuntimeException e) {
            I18n2 i18n = this.i18nFactoryService.getI18n();
            updatedContext = Maps.newHashMap();
            updatedContext.put("title", i18n.getText("gh.entity.pages.failed"));
        }
        return updatedContext;
    }

    private RemoteEntityLinkModel getModel(RemoteIssueLink remoteIssueLink, Map<String, Object> updatedContext) {
        Object title = updatedContext.get("title");
        String titleString = remoteIssueLink.getTitle();
        if (title != null) {
            titleString = title.toString();
        }
        RemoteEntityLinkModel model = new RemoteEntityLinkModel(remoteIssueLink.getId(), remoteIssueLink.getIssueId(), titleString, this.buildPageUrlWithSrc(remoteIssueLink.getUrl(), "epic"));
        if (updatedContext.containsKey("pageDeleted")) {
            model.pageDeleted = true;
        }
        if (updatedContext.containsKey("appLinkExists") && updatedContext.get("appLinkExists").equals(false)) {
            model.appLinkExists = false;
        }
        if (updatedContext.containsKey("permissionDenied")) {
            model.permissionDenied = (Boolean)updatedContext.get("permissionDenied");
        }
        if (updatedContext.containsKey("serverUnavailable")) {
            model.serverUnavailable = (Boolean)updatedContext.get("serverUnavailable");
        }
        if (updatedContext.containsKey("authenticationRequired")) {
            model.authenticationRequired = (Boolean)updatedContext.get("authenticationRequired");
        }
        if (updatedContext.containsKey("authenticationUrl")) {
            model.authenticationUrl = updatedContext.get("authenticationUrl").toString();
        }
        if (updatedContext.containsKey("appLinkId")) {
            model.applicationLinkId = updatedContext.get("appLinkId").toString();
        }
        model.pageId = this.extractPageIdFromGlobalId(remoteIssueLink.getGlobalId());
        return model;
    }
}

