/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.entity.common;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.greenhopper.global.LoggerWrapper;
import com.atlassian.greenhopper.web.rapid.entity.common.LinkedPagesModel;
import com.atlassian.jira.plugin.viewissue.issuelink.GlobalIdFactory;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.atlassian.plugins.capabilities.api.LinkedApplicationCapabilities;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class AbstractLinkedPagesModelFactory {
    protected static final String CONFLUENCE_APP_ID = "appId";
    protected static final String CONFLUENCE_PAGE_ID = "pageId";
    protected static final List<String> KEYS = ImmutableList.of((Object)"appId", (Object)"pageId");
    protected static final String CONFLUENCE_SRC = "src";
    protected static final String CONFLUENCE_JIRA_AGILE_SRC = "jiraagile";
    protected static final String CONFLUENCE_PAGE_DELETED = "pageDeleted";
    protected static final String CONFLUENCE_APP_LINK_EXISTS = "appLinkExists";
    protected static final String CONFLUENCE_PERMISSION_DENIED = "permissionDenied";
    protected static final String CONFLUENCE_SERVER_UNAVAILABLE = "serverUnavailable";
    protected static final String CONFLUENCE_AUTHENTICATION_REQUIRED = "authenticationRequired";
    protected static final String CONFLUENCE_AUTHENTICATION_URL = "authenticationUrl";
    protected static final String CONFLUENCE_APP_LINK_ID = "appLinkId";
    protected static final String CONFLUENCE_APP_NAME = "applicationName";
    protected static final String CONFLUENCE_APP_URL = "applicationUrl";
    protected static final String CONFLUENCE_NO_APPLINK_AUTH_CONFIGURED = "noApplinkAuthConfigured";
    protected static final String CONFLUENCE_TITLE = "Page";
    protected static final String CONFLUENCE_RELATIONSHIP_NAME = "Wiki Page";
    public static final String CREATE_CONTENT_WITH_INIT_CONTEXT = "create-content-with-init-context";
    public static final String CREATE_CONTENT_JIRA_REMOTE_LINK_CALLBACK = "created-content-jira-remote-link-callback";
    protected final LoggerWrapper log = LoggerWrapper.with(this.getClass());
    @Autowired
    protected ApplicationLinkService applicationLinkService;
    @Autowired
    private LinkedApplicationCapabilities linkedApplicationCapabilities;

    public List<LinkedPagesModel.ApplicationLinkModel> findSupportedConfluenceApplicationLinks() {
        ArrayList supportedLinks = Lists.newArrayList();
        Set<? extends LinkedAppWithCapabilities> apps = this.findCapableApplications();
        for (LinkedAppWithCapabilities linkedAppWithCapabilities : apps) {
            try {
                ApplicationLink appLink = this.applicationLinkService.getApplicationLink(new ApplicationId(linkedAppWithCapabilities.getApplicationLinkId()));
                if (appLink == null) continue;
                LinkedPagesModel.ApplicationLinkModel model = new LinkedPagesModel.ApplicationLinkModel();
                model.id = linkedAppWithCapabilities.getApplicationLinkId();
                model.name = appLink.getName();
                model.url = appLink.getDisplayUrl().toString();
                model.primary = appLink.isPrimary();
                supportedLinks.add(model);
            }
            catch (TypeNotInstalledException e) {
                this.log.warn("Type %s is not installed in this JIRA instance", linkedAppWithCapabilities.getType());
                this.log.exception(e);
            }
        }
        return supportedLinks;
    }

    public boolean hasPagesSupport() {
        Set<? extends LinkedAppWithCapabilities> apps = this.findCapableApplications();
        return !apps.isEmpty();
    }

    protected String buildPageUrl(ApplicationLink appLink, String pageId) {
        return new UrlBuilder(appLink.getDisplayUrl().toASCIIString()).addPathUnsafe("pages/viewpage.action").addParameter(CONFLUENCE_PAGE_ID, pageId).asUrlString();
    }

    private Set<? extends LinkedAppWithCapabilities> findCapableApplications() {
        Set capableApplications1 = this.linkedApplicationCapabilities.capableOf(CREATE_CONTENT_WITH_INIT_CONTEXT);
        Set capableApplications2 = this.linkedApplicationCapabilities.capableOf(CREATE_CONTENT_JIRA_REMOTE_LINK_CALLBACK);
        return Sets.intersection((Set)capableApplications1, (Set)capableApplications2);
    }

    protected Long extractPageIdFromUrl(String url) {
        List nameValuePairs = URLEncodedUtils.parse((URI)URI.create(url), (String)"UTF-8");
        for (NameValuePair nameValuePair : nameValuePairs) {
            if (!nameValuePair.getName().equals(CONFLUENCE_PAGE_ID)) continue;
            String value = nameValuePair.getValue();
            try {
                return Long.parseLong(value, 10);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    protected Long extractPageIdFromGlobalId(String globalId) {
        Map decodedGlobalId = GlobalIdFactory.decode((String)globalId, KEYS);
        String pageId = (String)decodedGlobalId.get(CONFLUENCE_PAGE_ID);
        try {
            return Long.parseLong(pageId, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    protected String buildPageUrlWithSrc(String pageUrl, String entityType) {
        return new UrlBuilder(pageUrl).addParameter(CONFLUENCE_SRC, "jiraagile." + entityType).asUrlString();
    }
}

