/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.data;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.util.data.JacksonJsonableMarshaller;
import com.atlassian.greenhopper.web.rapid.RapidBoardViewModelFactory;
import com.atlassian.greenhopper.web.rapid.RapidConfig;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.json.marshal.Jsonable;
import io.atlassian.fugue.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RapidViewConfigDataProvider {
    private static final Logger log = LoggerFactory.getLogger(RapidViewConfigDataProvider.class);
    private final RapidBoardViewModelFactory rapidViewFactory;
    private final JiraAuthenticationContext jiraAuthenticationContext;

    @Autowired
    public RapidViewConfigDataProvider(RapidBoardViewModelFactory rapidViewFactory, JiraAuthenticationContext jiraAuthenticationContext) {
        this.rapidViewFactory = rapidViewFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    public Option<Jsonable> getForRapidView(RapidView rapidView) {
        ServiceOutcome<RapidConfig> serviceOutcome = this.rapidViewFactory.getRapidViewConfigModel(this.getApplicationUser(), rapidView);
        if (serviceOutcome.isInvalid()) {
            log.warn("Could not fetch RapidConfig for board {}: {}", (Object)rapidView.getId(), (Object)serviceOutcome.getErrors());
            return Option.none();
        }
        return Option.some((Object)JacksonJsonableMarshaller.INSTANCE.marshal((Object)serviceOutcome.getValue()));
    }

    private ApplicationUser getApplicationUser() {
        return this.jiraAuthenticationContext.getLoggedInUser();
    }
}

