/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.config.tab;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.web.rapid.config.tab.BoardConfigTab;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptorComparator;
import com.atlassian.plugin.web.model.WebPanel;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public final class BoardConfigTabsResolver {
    private static final String BOARD_CONFIGURATION_LOCATION = "jira.agile.board.configuration";
    private final DynamicWebInterfaceManager dynamicWebInterfaceManager;

    @Autowired
    public BoardConfigTabsResolver(DynamicWebInterfaceManager dynamicWebInterfaceManager) {
        this.dynamicWebInterfaceManager = dynamicWebInterfaceManager;
    }

    public List<BoardConfigTab> getTabs(RapidView rapidView, HttpServletRequest request) {
        ImmutableMap context = ImmutableMap.of((Object)"board", (Object)rapidView);
        List configurationPanels = this.dynamicWebInterfaceManager.getDisplayableWebPanelDescriptors(BOARD_CONFIGURATION_LOCATION, (Map)context);
        return configurationPanels.stream().sorted(new WeightedDescriptorComparator()).map(SafePluginPointAccess.safe(arg_0 -> BoardConfigTabsResolver.lambda$getTabs$0((Map)context, request, arg_0))::apply).collect(Collectors.toList());
    }

    private static BoardConfigTab toBean(WebPanelModuleDescriptor moduleDescriptor, Map<String, Object> context, HttpServletRequest request) {
        String key = moduleDescriptor.getKey();
        String label = moduleDescriptor.getWebLabel().getDisplayableLabel(request, context);
        String html = ((WebPanel)moduleDescriptor.getModule()).getHtml(context);
        return new BoardConfigTab(key, label, html);
    }

    private static /* synthetic */ BoardConfigTab lambda$getTabs$0(Map context, HttpServletRequest request, WebPanelModuleDescriptor moduleDescriptor) {
        return BoardConfigTabsResolver.toBean(moduleDescriptor, context, request);
    }
}

