/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart.sprintreportfactory;

import com.atlassian.greenhopper.web.rapid.chart.EstimateValue;
import com.atlassian.greenhopper.web.rapid.chart.HistoricSprintReportContents;
import com.atlassian.greenhopper.web.rapid.chart.sprintreportfactory.AddedDuringIssueEstimateCalculator;
import com.atlassian.greenhopper.web.rapid.chart.sprintreportfactory.CompletedInAnotherSprintIssueEstimateCalculator;
import com.atlassian.greenhopper.web.rapid.chart.sprintreportfactory.CompletedIssueEstimateCalculator;
import com.atlassian.greenhopper.web.rapid.chart.sprintreportfactory.IssueEstimateCalculator;
import com.atlassian.greenhopper.web.rapid.chart.sprintreportfactory.NotCompletedIssueEstimateCalculator;
import com.atlassian.greenhopper.web.rapid.chart.sprintreportfactory.RemovedIssueEstimateCalculator;
import com.atlassian.greenhopper.web.rapid.issue.StatisticFieldHelper;
import com.atlassian.greenhopper.web.rapid.issue.StatusEntryFactory;
import com.atlassian.greenhopper.web.rapid.issue.statistics.HistoricalEstimateStatisticValueResolver;
import com.atlassian.greenhopper.web.rapid.issue.statistics.IssueSprintStatistics;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.EntityData;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.StatusManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class HistoricSprintReportContentsFactory {
    private final List<RapidIssueEntry> issuesList;
    private final HistoricalEstimateStatisticValueResolver historicalEstimateStatisticValueResolver;
    private final IssueService issueService;
    private final ApplicationUser loggedInUser;
    private final StatisticFieldHelper statisticFieldHelper;
    private final StatusManager statusManager;
    private final StatusEntryFactory statusEntryFactory;
    private final EntityData entityData;

    public HistoricSprintReportContentsFactory(CollectIssuesResult issuesResult, HistoricalEstimateStatisticValueResolver historicalEstimateStatisticValueResolver, IssueService issueService, ApplicationUser loggedInUser, StatisticFieldHelper statisticFieldHelper, StatusManager statusManager, StatusEntryFactory statusEntryFactory) {
        this.issuesList = issuesResult.getIssues();
        this.entityData = issuesResult.getEntityData();
        this.historicalEstimateStatisticValueResolver = historicalEstimateStatisticValueResolver;
        this.issueService = issueService;
        this.loggedInUser = loggedInUser;
        this.statisticFieldHelper = statisticFieldHelper;
        this.statusManager = statusManager;
        this.statusEntryFactory = statusEntryFactory;
    }

    public HistoricSprintReportContents create() {
        List<? extends IssueEstimateCalculator> endStateCalculators = this.createEndStateCalculators();
        AddedDuringIssueEstimateCalculator addedDuringCalculator = new AddedDuringIssueEstimateCalculator();
        for (RapidIssueEntry issueEntry : this.issuesList) {
            IssueService.IssueResult issueResult;
            IssueSprintStatistics issueSprintStatistics = this.historicalEstimateStatisticValueResolver.getIssueSprintStatistics(issueEntry.key);
            if (issueSprintStatistics == null || issueSprintStatistics.issueStatusAtEndOfSprint == null || !(issueResult = this.issueService.getIssue(this.loggedInUser, issueEntry.key)).isValid()) continue;
            this.prepareIssueEntryForCalculation(issueEntry, issueSprintStatistics, issueResult);
            for (IssueEstimateCalculator issueEstimateCalculator : endStateCalculators) {
                if (!issueEstimateCalculator.canHandleIssue(issueSprintStatistics)) continue;
                issueEstimateCalculator.add(issueEntry);
                break;
            }
            if (!addedDuringCalculator.canHandleIssue(issueSprintStatistics)) continue;
            addedDuringCalculator.add(issueEntry);
        }
        HistoricSprintReportContents contents = new HistoricSprintReportContents();
        EstimateValue allIssuesEstimateSum = new EstimateValue();
        Iterable allCalculators = Iterables.concat(endStateCalculators, Collections.singleton(addedDuringCalculator));
        for (IssueEstimateCalculator calculator : allCalculators) {
            calculator.fillIntoReportContents(contents);
            allIssuesEstimateSum.add(calculator.getCurrentEstimateSum());
        }
        contents.allIssuesEstimateSum = new RapidIssueEntry.NumberFieldValue(allIssuesEstimateSum.get());
        contents.entityData = this.entityData;
        return contents;
    }

    private List<? extends IssueEstimateCalculator> createEndStateCalculators() {
        return Arrays.asList(new CompletedIssueEstimateCalculator(), new RemovedIssueEstimateCalculator(), new CompletedInAnotherSprintIssueEstimateCalculator(), new NotCompletedIssueEstimateCalculator());
    }

    private void prepareIssueEntryForCalculation(RapidIssueEntry issueEntry, IssueSprintStatistics issueSprintStatistics, IssueService.IssueResult issueResult) {
        issueEntry.estimateStatistic = this.statisticFieldHelper.createEstimateStatistic((Issue)issueResult.getIssue(), this.historicalEstimateStatisticValueResolver);
        issueEntry.currentEstimateStatistic = this.statisticFieldHelper.createCurrentEstimateStatistic((Issue)issueResult.getIssue(), this.historicalEstimateStatisticValueResolver);
        Status status = this.statusManager.getStatus(issueSprintStatistics.issueStatusAtEndOfSprint);
        if (status != null) {
            issueEntry.statusId = status.getId();
            this.entityData.collectStatus(status.getId(), status.getName(), status.getIconUrlHtml(), this.statusEntryFactory.createStatusEntry(status));
        }
    }
}

