/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart.integration;

import com.atlassian.greenhopper.api.rapid.configuration.LabsConfigurationService;
import com.atlassian.greenhopper.web.api.ProjectPageContextParameters;
import com.atlassian.jira.plugin.report.ReportModuleDescriptor;
import com.atlassian.jira.plugin.report.ReportUrlProvider;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.JiraUrlCodec;
import io.atlassian.fugue.Option;
import java.util.Map;

public class AgileReportUrlProvider
implements ReportUrlProvider {
    private static final String REPORT_TEMPLATE = "/secure/RapidBoard.jspa?projectKey=%s&rapidView=%s&view=reporting&chart=%s";
    private final LabsConfigurationService configurationService;

    public AgileReportUrlProvider(LabsConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public Option<String> getUrl(ReportModuleDescriptor descriptor, Map<String, Object> context) {
        boolean isForSprint;
        Option<Long> rapidViewId = this.getRapidViewIdFromContext(context);
        Project project = (Project)context.get("project");
        if (project == null || rapidViewId.isEmpty()) {
            return Option.none();
        }
        String urlName = (String)descriptor.getParams().get("urlName");
        if (urlName == null) {
            return Option.none();
        }
        boolean bl = isForSprint = !Boolean.parseBoolean((String)descriptor.getParams().get("notForSprint"));
        if (isForSprint && !this.configurationService.isSprintSupportEnabled((Long)rapidViewId.get())) {
            return Option.none();
        }
        return Option.some((Object)String.format(REPORT_TEMPLATE, JiraUrlCodec.encode((String)project.getKey()), JiraUrlCodec.encode((String)((Long)rapidViewId.get()).toString()), JiraUrlCodec.encode((String)urlName)));
    }

    private Option<Long> getRapidViewIdFromContext(Map<String, Object> context) {
        Long rapidView = (Long)context.get(ProjectPageContextParameters.SELECTED_BOARD_ID.getKey());
        return Option.option((Object)rapidView);
    }
}

