/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart.burndown;

import com.atlassian.greenhopper.service.sprint.SprintStateAuditEntry;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class BurndownStateChange
implements Comparable<BurndownStateChange> {
    @XmlTransient
    public DateTime date;
    @XmlElement
    public String userDisplayNameHtml;
    @XmlElement
    public SprintStateAuditEntry.Operation operation;

    public BurndownStateChange() {
    }

    private BurndownStateChange(DateTime date, String userDisplayNameHtml, SprintStateAuditEntry.Operation operation) {
        this.date = date;
        this.userDisplayNameHtml = userDisplayNameHtml;
        this.operation = operation;
    }

    public DateTime getDate() {
        return this.date;
    }

    @Override
    public int compareTo(BurndownStateChange o) {
        if (this.date == null) {
            return 1;
        }
        if (o == null) {
            return -1;
        }
        return this.date.compareTo((ReadableInstant)o.getDate());
    }

    public static BurndownStateChangeBuilder builder() {
        return new BurndownStateChangeBuilder();
    }

    public static class BurndownStateChangeBuilder {
        private DateTime date;
        private String userDisplayNameHtml;
        private SprintStateAuditEntry.Operation operation;

        public BurndownStateChangeBuilder date(DateTime date) {
            this.date = date;
            return this;
        }

        public BurndownStateChangeBuilder userDisplayNameHtml(String userDisplayNameHtml) {
            this.userDisplayNameHtml = userDisplayNameHtml;
            return this;
        }

        public BurndownStateChangeBuilder operation(SprintStateAuditEntry.Operation operation) {
            this.operation = operation;
            return this;
        }

        public BurndownStateChange build() {
            return new BurndownStateChange(this.date, this.userDisplayNameHtml, this.operation);
        }
    }
}

