/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart.burndown;

import com.atlassian.greenhopper.model.rapid.Column;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.validation.ErrorCollection;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.charts.IssueStatusHistoryService;
import com.atlassian.greenhopper.service.rapid.MappedStatusIds;
import com.atlassian.greenhopper.service.rapid.RapidViewColumnService;
import com.atlassian.greenhopper.service.workflow.WorkflowService;
import com.atlassian.greenhopper.web.rapid.chart.IssueColumnChangeCollector;
import com.atlassian.greenhopper.web.rapid.chart.IssueColumnChangeEntry;
import com.atlassian.greenhopper.web.rapid.chart.SwimlaneFilter;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownColumnChangeData;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableSortedMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BurndownColumnChangeFactory {
    @Autowired
    private IssueStatusHistoryService issueStatusHistoryService;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private RapidViewColumnService rapidViewColumnService;

    public ServiceOutcome<BurndownColumnChangeData> getBurndownColumnChangeData(ApplicationUser user, RapidView rapidView, Collection<String> issueKeys) {
        ServiceOutcome<List<Column>> columns = this.getBurndownColumns(user, rapidView);
        if (!columns.isValid()) {
            return ServiceOutcomeImpl.error(columns);
        }
        if (issueKeys.size() == 0) {
            return ServiceOutcomeImpl.ok(new BurndownColumnChangeData(columns.getValue(), (SortedMap<Long, Map<String, IssueColumnChangeEntry>>)ImmutableSortedMap.of()));
        }
        Query query = JqlQueryBuilder.newBuilder().where().issue(issueKeys.toArray(new String[issueKeys.size()])).buildQuery();
        SwimlaneFilter swimlaneFilter = SwimlaneFilter.allSwimlanes();
        IssueColumnChangeCollector collector = new IssueColumnChangeCollector(columns.getValue(), this.fromStatusToColumn(columns.getValue()), swimlaneFilter);
        ServiceOutcome<Void> outcome = this.issueStatusHistoryService.collectStatusHistory(user, query, collector);
        if (!outcome.isValid()) {
            return ServiceOutcomeImpl.error(outcome);
        }
        return ServiceOutcomeImpl.ok(new BurndownColumnChangeData(columns.getValue(), collector.getColumnChanges()));
    }

    private ServiceOutcome<List<Column>> getBurndownColumns(ApplicationUser user, RapidView rapidView) {
        ServiceOutcome<MappedStatusIds> mappedStatusIds = this.rapidViewColumnService.getMappedStatusIds(user, rapidView);
        if (!mappedStatusIds.isValid()) {
            return ServiceOutcomeImpl.error(mappedStatusIds);
        }
        MappedStatusIds statusIds = mappedStatusIds.getValue();
        if (statusIds.getDoneStatusIds().size() == 0 || statusIds.getNotDoneStatusIds().size() == 0) {
            return ServiceOutcomeImpl.error(ErrorCollection.Reason.SERVER_ERROR, "At least two columns required in order to construct a burndown chart", new Object[0]);
        }
        Column notDoneColumn = Column.builder().id(1L).statusIds(new LinkedList<String>(statusIds.getNotDoneStatusIds())).name("Not done").build();
        Column doneColumn = Column.builder().id(2L).statusIds(new LinkedList<String>(statusIds.getDoneStatusIds())).name("Done").build();
        ArrayList<Column> result = new ArrayList<Column>();
        result.add(notDoneColumn);
        result.add(doneColumn);
        return ServiceOutcomeImpl.ok(result);
    }

    private Map<Status, Column> fromStatusToColumn(List<Column> columns) {
        HashMap<Status, Column> columnsByStatus = new HashMap<Status, Column>();
        for (Column column : columns) {
            for (String statusId : column.getStatusIds()) {
                Status status = this.workflowService.getWorkflowStatusObject(statusId);
                if (status == null) continue;
                columnsByStatus.put(status, column);
            }
        }
        return columnsByStatus;
    }
}

