/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart.burndown;

import com.atlassian.greenhopper.customfield.epiclink.EpicLinkHistoryEntry;
import com.atlassian.greenhopper.customfield.sprint.SprintHistoryEntry;
import com.atlassian.greenhopper.model.rapid.AuditEntry;
import com.atlassian.greenhopper.service.sprint.Sprint;
import com.atlassian.greenhopper.service.sprint.SprintStateAuditEntry;
import com.atlassian.greenhopper.service.timetracking.TimeTrackingHistoryService;
import com.atlassian.greenhopper.web.rapid.GHJSONMarshaller;
import com.atlassian.greenhopper.web.rapid.chart.FixVersionChangeEntry;
import com.atlassian.greenhopper.web.rapid.chart.FlotChartUtils;
import com.atlassian.greenhopper.web.rapid.chart.IssueColumnChangeEntry;
import com.atlassian.greenhopper.web.rapid.chart.StatisticHistoryEntry;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BaseStatisticChange;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownChange;
import com.atlassian.greenhopper.web.rapid.chart.burndown.BurndownStateChange;
import com.atlassian.greenhopper.web.rapid.chart.burndown.ColumnChange;
import com.atlassian.greenhopper.web.rapid.chart.burndown.TimeTrackingChange;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class BurndownChangeUtil {
    public static void optimizeBurndownChanges(Map<String, List<BurndownChange>> changesPerIssue) {
        for (List<BurndownChange> issueChanges : changesPerIssue.values()) {
            Collections.sort(issueChanges, new Comparator<BurndownChange>(){

                @Override
                public int compare(BurndownChange o1, BurndownChange o2) {
                    return o1.date.compareTo((ReadableInstant)o2.date);
                }
            });
            for (int i = 0; i < issueChanges.size() - 1; ++i) {
                BurndownChange second;
                BurndownChange first = issueChanges.get(i);
                if (!first.canMergeChange(second = issueChanges.get(i + 1))) continue;
                first.mergeChanges(second);
                issueChanges.remove(i + 1);
                --i;
            }
        }
    }

    public static SortedMap<Long, List<BurndownChange>> transformChangesToTimeline(TimeZone userTimeZone, Map<String, List<BurndownChange>> changes) {
        TreeMap<Long, List<BurndownChange>> result = new TreeMap<Long, List<BurndownChange>>();
        for (Map.Entry<String, List<BurndownChange>> entry : changes.entrySet()) {
            for (BurndownChange change : entry.getValue()) {
                long adaptedMillis = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, change.date);
                ArrayList<BurndownChange> changesPerInstant = (ArrayList<BurndownChange>)result.get(adaptedMillis);
                if (changesPerInstant == null) {
                    changesPerInstant = new ArrayList<BurndownChange>();
                    result.put(adaptedMillis, changesPerInstant);
                }
                changesPerInstant.add(change);
                if (change.timeC == null) continue;
                change.timeC.changeDate = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, change.timeC.changeDateObject);
            }
        }
        return result;
    }

    public static void addStatisticsValueChanges(DateTime sprintStart, DateTime upperTimeRange, Map<String, List<StatisticHistoryEntry>> statisticsValueHistory, Map<String, List<BurndownChange>> changesPerIssue) {
        for (Map.Entry<String, List<StatisticHistoryEntry>> perIssue : statisticsValueHistory.entrySet()) {
            String issueKey = perIssue.getKey();
            List<BurndownChange> changes = BurndownChangeUtil.getChangesPerIssueSafe(changesPerIssue, issueKey);
            boolean isBeforeStart = true;
            StatisticHistoryEntry first = null;
            Double oldValue = null;
            for (StatisticHistoryEntry entry : perIssue.getValue()) {
                if (isBeforeStart) {
                    if (!entry.getDate().isAfter((ReadableInstant)sprintStart)) {
                        first = entry;
                        continue;
                    }
                    isBeforeStart = false;
                    if (first != null) {
                        changes.add(BurndownChangeUtil.toChange(issueKey, oldValue, first));
                        oldValue = first.getValue();
                        first = null;
                    }
                }
                if (upperTimeRange != null && !upperTimeRange.isAfter((ReadableInstant)entry.getDate())) continue;
                changes.add(BurndownChangeUtil.toChange(issueKey, oldValue, entry));
                oldValue = entry.getValue();
            }
            if (first == null) continue;
            changes.add(BurndownChangeUtil.toChange(issueKey, oldValue, first));
            first = null;
        }
    }

    public static SortedMap<Long, List<BurndownStateChange>> transformStateChangesToTimeline(TimeZone userTimeZone, UserFormats userFormats, SortedSet<AuditEntry> entries, GHJSONMarshaller ghjsonMarshaller) {
        TreeMap<Long, List<BurndownStateChange>> result = new TreeMap<Long, List<BurndownStateChange>>();
        for (AuditEntry entry : entries) {
            String userKey = entry.getUser();
            long adaptedMillis = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, entry.getTime());
            List changesPerInstant = (List)result.get(adaptedMillis);
            if (changesPerInstant == null) {
                changesPerInstant = Lists.newArrayList();
                result.put(adaptedMillis, changesPerInstant);
            }
            SprintStateAuditEntry stateChangeAuditEntryData = ghjsonMarshaller.unmarshalJSON(entry.getData(), SprintStateAuditEntry.class);
            BurndownStateChange change = BurndownStateChange.builder().date(entry.getTime()).userDisplayNameHtml(BurndownChangeUtil.getProfileLinkFromUserKey(userFormats, userKey)).operation(stateChangeAuditEntryData.getOperation()).build();
            changesPerInstant.add(change);
        }
        return result;
    }

    public static String getProfileLinkFromUserKey(UserFormats userFormats, String userKey) {
        return userFormats.formatter("profileLink").formatUserkey(userKey, "");
    }

    private static BurndownChange toChange(String issueKey, Double oldValue, StatisticHistoryEntry entry) {
        BurndownChange change = new BurndownChange();
        change.key = issueKey;
        change.date = entry.getDate();
        BaseStatisticChange statChange = new BaseStatisticChange();
        statChange.oldValue = oldValue;
        statChange.newValue = entry.getValue();
        change.statC = statChange;
        return change;
    }

    public static void addColumnChanges(DateTime startDate, @Nullable DateTime endDate, SortedMap<Long, Map<String, IssueColumnChangeEntry>> columnChanges, Map<String, List<BurndownChange>> changesPerIssue, boolean trimIntraColumnMoves) {
        Map<String, List<BurndownChange>> transformedColumnChanges = BurndownChangeUtil.transformToPerIssueForm(columnChanges, trimIntraColumnMoves);
        for (Map.Entry<String, List<BurndownChange>> perIssue : transformedColumnChanges.entrySet()) {
            String issueKey = perIssue.getKey();
            List<BurndownChange> changes = BurndownChangeUtil.getChangesPerIssueSafe(changesPerIssue, issueKey);
            boolean isBeforeStart = true;
            BurndownChange first = null;
            for (BurndownChange entry : perIssue.getValue()) {
                if (isBeforeStart) {
                    if (!entry.date.isAfter((ReadableInstant)startDate)) {
                        first = entry;
                        continue;
                    }
                    isBeforeStart = false;
                    if (first != null) {
                        changes.add(first);
                        first = null;
                    }
                }
                if (endDate != null && !endDate.isAfter((ReadableInstant)entry.getDate())) continue;
                changes.add(entry);
            }
            if (first == null) continue;
            changes.add(first);
            first = null;
        }
    }

    private static Map<String, List<BurndownChange>> transformToPerIssueForm(SortedMap<Long, Map<String, IssueColumnChangeEntry>> columnChanges, boolean trimIntraColumnMoves) {
        HashMap<String, List<BurndownChange>> changes = new HashMap<String, List<BurndownChange>>();
        for (Map.Entry<Long, Map<String, IssueColumnChangeEntry>> perTimestamp : columnChanges.entrySet()) {
            DateTime date = new DateTime((Object)perTimestamp.getKey());
            for (Map.Entry<String, IssueColumnChangeEntry> entry : perTimestamp.getValue().entrySet()) {
                String issueKey = entry.getKey();
                List<BurndownChange> perIssueChanges = BurndownChangeUtil.getChangesPerIssueSafe(changes, issueKey);
                if ((!trimIntraColumnMoves || !BurndownChangeUtil.isValidChangeColumnChangeEntry(entry.getValue())) && trimIntraColumnMoves) continue;
                perIssueChanges.add(BurndownChangeUtil.toChange(date, issueKey, entry.getValue()));
            }
        }
        return changes;
    }

    private static boolean isValidChangeColumnChangeEntry(IssueColumnChangeEntry entry) {
        Integer from = entry.columnFrom;
        Integer to = entry.columnTo;
        if (from == null) {
            return to != null;
        }
        return !from.equals(to);
    }

    private static BurndownChange toChange(DateTime date, String issueKey, IssueColumnChangeEntry entry) {
        BurndownChange change = new BurndownChange();
        change.key = issueKey;
        change.date = date;
        ColumnChange columnChange = new ColumnChange();
        if (entry.columnFrom != null) {
            if (entry.columnFrom == 0) {
                columnChange.notDone = false;
            } else {
                columnChange.done = false;
            }
        }
        if (entry.columnTo != null) {
            if (entry.columnTo == 0) {
                columnChange.notDone = true;
            } else {
                columnChange.done = true;
            }
        }
        if (entry.statusTo != null) {
            columnChange.newStatus = entry.statusTo;
        }
        change.column = columnChange;
        return change;
    }

    public static void addSprintHistoryChanges(DateTime sprintStart, DateTime upperTimeRange, Map<String, List<SprintHistoryEntry>> sprintHistory, Map<String, List<BurndownChange>> changesPerIssue) {
        for (Map.Entry<String, List<SprintHistoryEntry>> perIssue : sprintHistory.entrySet()) {
            String issueKey = perIssue.getKey();
            List<BurndownChange> changes = BurndownChangeUtil.getChangesPerIssueSafe(changesPerIssue, issueKey);
            boolean isBeforeStart = true;
            SprintHistoryEntry first = null;
            for (SprintHistoryEntry entry : perIssue.getValue()) {
                if (isBeforeStart) {
                    if (!entry.getDate().isAfter((ReadableInstant)sprintStart)) {
                        first = entry;
                        continue;
                    }
                    isBeforeStart = false;
                    if (first != null && first.isAdded()) {
                        changes.add(BurndownChangeUtil.toChange(issueKey, first));
                        first = null;
                    }
                }
                if (upperTimeRange != null && !upperTimeRange.isAfter((ReadableInstant)entry.getDate())) continue;
                changes.add(BurndownChangeUtil.toChange(issueKey, entry));
            }
            if (first == null) continue;
            changes.add(BurndownChangeUtil.toChange(issueKey, first));
            first = null;
        }
    }

    public static Map<String, List<SprintHistoryEntry>> filterSprintHistoryEntriesBeforeSprintStart(Sprint sprint, Map<String, List<SprintHistoryEntry>> sprintHistoryMap) {
        Validate.notNull((Object)sprint);
        Validate.notNull(sprintHistoryMap);
        HashMap result = Maps.newHashMapWithExpectedSize((int)sprintHistoryMap.size());
        for (String issueKey : sprintHistoryMap.keySet()) {
            ArrayList entries = Lists.newArrayList((Iterable)sprintHistoryMap.get(issueKey));
            SprintHistoryEntry added = null;
            SprintHistoryEntry removed = null;
            ArrayList toRemove = Lists.newArrayList();
            for (SprintHistoryEntry entry : entries) {
                if (!sprint.getId().equals(entry.getSprintId())) continue;
                if (entry.getDate().isAfter((ReadableInstant)sprint.getStartDate())) break;
                if (entry.isAdded()) {
                    added = entry;
                } else {
                    removed = entry;
                }
                if (added == null || removed == null) continue;
                toRemove.add(added);
                toRemove.add(removed);
                added = null;
                removed = null;
            }
            entries.removeAll(toRemove);
            if (entries.isEmpty()) continue;
            result.put(issueKey, entries);
        }
        return result;
    }

    private static BurndownChange toChange(String issueKey, SprintHistoryEntry entry) {
        BurndownChange change = new BurndownChange();
        change.key = issueKey;
        change.date = entry.getDate();
        change.added = entry.isAdded();
        return change;
    }

    public static void addTimeTrackingChanges(DateTime sprintStart, DateTime upperTimeRange, Map<String, List<TimeTrackingHistoryService.HistoryEntry>> timeTrackingHistory, Map<String, List<BurndownChange>> changesPerIssue) {
        for (Map.Entry<String, List<TimeTrackingHistoryService.HistoryEntry>> perIssue : timeTrackingHistory.entrySet()) {
            String issueKey = perIssue.getKey();
            List<BurndownChange> changes = BurndownChangeUtil.getChangesPerIssueSafe(changesPerIssue, issueKey);
            for (TimeTrackingHistoryService.HistoryEntry entry : perIssue.getValue()) {
                changes.add(BurndownChangeUtil.toChange(issueKey, entry));
            }
        }
    }

    private static BurndownChange toChange(String issueKey, TimeTrackingHistoryService.HistoryEntry entry) {
        BurndownChange change = new BurndownChange();
        change.key = issueKey;
        change.date = entry.getLogDate();
        if (change.date == null) {
            change.date = entry.getChangeDate();
        }
        TimeTrackingChange timeChange = new TimeTrackingChange();
        timeChange.oldEstimate = entry.getRemainingEstimateBefore();
        timeChange.newEstimate = entry.getRemainingEstimateAfter();
        timeChange.timeSpent = entry.getTimeSpent();
        timeChange.changeDateObject = entry.getChangeDate();
        change.timeC = timeChange;
        return change;
    }

    public static void addEpicHistoryChanges(Map<String, List<EpicLinkHistoryEntry>> epicHistory, HashMap<String, List<BurndownChange>> changes) {
        for (Map.Entry<String, List<EpicLinkHistoryEntry>> perIssue : epicHistory.entrySet()) {
            String issueKey = perIssue.getKey();
            List<BurndownChange> burndownChanges = BurndownChangeUtil.getChangesPerIssueSafe(changes, issueKey);
            for (EpicLinkHistoryEntry entry : perIssue.getValue()) {
                burndownChanges.add(BurndownChangeUtil.toChange(issueKey, entry));
            }
        }
    }

    public static void addVersionHistoryChanges(Map<String, List<FixVersionChangeEntry>> history, HashMap<String, List<BurndownChange>> changes) {
        for (Map.Entry<String, List<FixVersionChangeEntry>> perIssue : history.entrySet()) {
            String issueKey = perIssue.getKey();
            List<BurndownChange> burndownChanges = BurndownChangeUtil.getChangesPerIssueSafe(changes, issueKey);
            for (FixVersionChangeEntry entry : perIssue.getValue()) {
                burndownChanges.add(BurndownChangeUtil.toChange(issueKey, entry));
            }
        }
    }

    private static BurndownChange toChange(String issueKey, EpicLinkHistoryEntry entry) {
        BurndownChange change = new BurndownChange();
        change.key = issueKey;
        change.date = entry.getDate();
        change.added = entry.isAdded();
        return change;
    }

    private static BurndownChange toChange(String issueKey, FixVersionChangeEntry entry) {
        BurndownChange change = new BurndownChange();
        change.key = issueKey;
        change.date = entry.date;
        change.added = entry.added;
        return change;
    }

    private static <K> List<BurndownChange> getChangesPerIssueSafe(Map<K, List<BurndownChange>> changesPerIssue, K issueKey) {
        List<BurndownChange> changes = changesPerIssue.get(issueKey);
        if (changes == null) {
            changes = new ArrayList<BurndownChange>();
            changesPerIssue.put(issueKey, changes);
        }
        return changes;
    }
}

