/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart.burndown;

import com.atlassian.greenhopper.web.rapid.chart.burndown.BaseStatisticChange;
import com.atlassian.greenhopper.web.rapid.chart.burndown.ColumnChange;
import com.atlassian.greenhopper.web.rapid.chart.burndown.TimeTrackingChange;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@XmlRootElement
public class BurndownChange {
    @XmlTransient
    public DateTime date;
    @XmlElement
    public String key;
    @XmlElement
    public BaseStatisticChange statC;
    @XmlElement
    public TimeTrackingChange timeC;
    @XmlElement
    public Boolean added;
    @XmlElement
    public ColumnChange column;

    public BurndownChange() {
    }

    private BurndownChange(DateTime date, String key, BaseStatisticChange statC, TimeTrackingChange timeC, Boolean added, ColumnChange column) {
        this.date = date;
        this.key = key;
        this.statC = statC;
        this.timeC = timeC;
        this.added = added;
        this.column = column;
    }

    public void mergeChanges(BurndownChange other) {
        if (other.statC != null) {
            this.statC = other.statC;
        }
        if (other.added != null) {
            this.added = other.added;
        }
        if (other.column != null) {
            this.column = other.column;
        }
        if (other.timeC != null) {
            this.timeC = other.timeC;
        }
    }

    public boolean canMergeChange(BurndownChange other) {
        if (this.date.compareTo((ReadableInstant)other.date) != 0) {
            return false;
        }
        return this.timeC == null || other.timeC == null;
    }

    public DateTime getDate() {
        return this.date;
    }

    public static BurndownChangeBuilder builder() {
        return new BurndownChangeBuilder();
    }

    public static class BurndownChangeBuilder {
        private DateTime date;
        private String key;
        private BaseStatisticChange statC;
        private TimeTrackingChange timeC;
        private Boolean added;
        private ColumnChange column;

        public BurndownChangeBuilder date(DateTime date) {
            this.date = date;
            return this;
        }

        public BurndownChangeBuilder key(String key) {
            this.key = key;
            return this;
        }

        public BurndownChangeBuilder statC(BaseStatisticChange statC) {
            this.statC = statC;
            return this;
        }

        public BurndownChangeBuilder timeC(TimeTrackingChange timeC) {
            this.timeC = timeC;
            return this;
        }

        public BurndownChangeBuilder added(Boolean added) {
            this.added = added;
            return this;
        }

        public BurndownChangeBuilder column(ColumnChange column) {
            this.column = column;
            return this;
        }

        public BurndownChange build() {
            return new BurndownChange(this.date, this.key, this.statC, this.timeC, this.added, this.column);
        }
    }
}

