/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.model.charts.WorkRateEntry;
import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.charts.WorkRateService;
import com.atlassian.greenhopper.web.rapid.chart.FlotChartUtils;
import com.atlassian.greenhopper.web.rapid.chart.SprintTimes;
import com.atlassian.greenhopper.web.rapid.chart.time.WorkRateData;
import com.atlassian.jira.user.ApplicationUser;
import java.util.ArrayList;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkRateDataFactory {
    @Autowired
    private WorkRateService workRateService;

    public ServiceOutcome<WorkRateData> getWorkRateData(ApplicationUser user, RapidView rapidView, SprintTimes sprintTimes, TimeZone userTimeZone) {
        return this.getWorkRateData(user, rapidView, userTimeZone, sprintTimes.getStartTime(), sprintTimes.getUpperTimeRange());
    }

    public ServiceOutcome<WorkRateData> getWorkRateData(ApplicationUser user, RapidView rapidView, TimeZone userTimeZone, DateTime startDate, DateTime endDate) {
        ServiceOutcome<com.atlassian.greenhopper.model.charts.WorkRateData> rateData = this.workRateService.getRateData(user, rapidView, startDate, endDate);
        if (!rateData.isValid()) {
            return ServiceOutcomeImpl.error(rateData);
        }
        return this.toWorkRateData(userTimeZone, rateData.getValue());
    }

    public ServiceOutcome<WorkRateData> toWorkRateData(TimeZone userTimeZone, com.atlassian.greenhopper.model.charts.WorkRateData rateData) {
        ArrayList<WorkRateData.RateEntry> entries = new ArrayList<WorkRateData.RateEntry>();
        for (WorkRateEntry rate : rateData.getRates()) {
            WorkRateData.RateEntry entry = new WorkRateData.RateEntry();
            entry.start = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, rate.getStart());
            entry.end = FlotChartUtils.prepareDateTimeForFlot(userTimeZone, rate.getEnd());
            entry.rate = rate.getRate();
            entries.add(entry);
        }
        WorkRateData data = new WorkRateData();
        data.timezone = rateData.getDateTimeZone().toString();
        data.rates = entries;
        return ServiceOutcomeImpl.ok(data);
    }
}

