/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.greenhopper.web.rapid.chart;

import com.atlassian.greenhopper.model.rapid.RapidView;
import com.atlassian.greenhopper.model.rapid.WorkingDaysConfig;
import com.atlassian.greenhopper.service.ServiceOutcome;
import com.atlassian.greenhopper.service.ServiceOutcomeImpl;
import com.atlassian.greenhopper.service.rapid.MappedStatusIds;
import com.atlassian.greenhopper.service.rapid.RapidViewColumnService;
import com.atlassian.greenhopper.service.rapid.view.workingdays.WorkingDaysService;
import com.atlassian.greenhopper.web.rapid.chart.ReportContentModel;
import com.atlassian.greenhopper.web.rapid.chart.ReportModelFactory;
import com.atlassian.greenhopper.web.rapid.chart.VersionEntry;
import com.atlassian.greenhopper.web.rapid.chart.VersionEntryFactory;
import com.atlassian.greenhopper.web.rapid.chart.VersionReportModel;
import com.atlassian.greenhopper.web.rapid.list.CollectIssuesResult;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntry;
import com.atlassian.greenhopper.web.rapid.list.RapidIssueEntryQueryService;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.timezone.TimeZoneManager;
import com.atlassian.jira.user.ApplicationUser;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.joda.time.DateTimeZone;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionReportModelFactory
extends ReportModelFactory {
    @Autowired
    private RapidIssueEntryQueryService rapidIssueEntryQueryService;
    @Autowired
    private RapidViewColumnService rapidViewColumnService;
    @Autowired
    private TimeZoneManager timeZoneManager;
    @Autowired
    private VersionEntryFactory versionEntryFactory;
    @Autowired
    private WorkingDaysService workingDaysService;

    public ServiceOutcome<VersionReportModel> getVersionReportContents(ApplicationUser user, RapidView rapidView, Version version) {
        TimeZone userTimeZone = this.timeZoneManager.getLoggedInUserTimeZone();
        ServiceOutcome<CollectIssuesResult> versionIssuesResult = this.rapidIssueEntryQueryService.collectIssuesForVersion(user, rapidView, version);
        if (!versionIssuesResult.isValid()) {
            return ServiceOutcomeImpl.error(versionIssuesResult);
        }
        ServiceOutcome<WorkingDaysConfig> workingDaysConfigurationOutcome = this.workingDaysService.getWorkingDaysConfiguration(user, rapidView);
        if (workingDaysConfigurationOutcome.isInvalid()) {
            return ServiceOutcomeImpl.error(workingDaysConfigurationOutcome);
        }
        DateTimeZone boardDateTimeZone = this.workingDaysService.getDateTimeZone(workingDaysConfigurationOutcome.getValue());
        VersionReportModel reportModel = new VersionReportModel();
        ServiceOutcome<VersionEntry> versionEntry = this.versionEntryFactory.constructVersionEntry(version, userTimeZone, boardDateTimeZone);
        if (!versionEntry.isValid()) {
            return ServiceOutcomeImpl.error(versionEntry);
        }
        reportModel.version = versionEntry.getValue();
        double completedIssuesEstimateSum = 0.0;
        double incompletedIssuesEstimateSum = 0.0;
        CollectIssuesResult issuesResult = versionIssuesResult.getValue();
        List<RapidIssueEntry> issues = issuesResult.getIssues();
        HashSet<String> epicKeys = new HashSet<String>();
        for (RapidIssueEntry issue : issues) {
            if (issue.epic == null) continue;
            epicKeys.add(issue.epic);
        }
        ServiceOutcome<CollectIssuesResult> epicsResult = this.rapidIssueEntryQueryService.collectEpicIssues(user, rapidView, epicKeys);
        if (!epicsResult.isValid()) {
            return ServiceOutcomeImpl.error(epicsResult);
        }
        List<RapidIssueEntry> epics = epicsResult.getValue().getIssues();
        ReportContentModel reportContent = new ReportContentModel();
        ServiceOutcome<MappedStatusIds> mappedStatusIds = this.rapidViewColumnService.getMappedStatusIds(user, rapidView);
        if (!mappedStatusIds.isValid()) {
            return ServiceOutcomeImpl.error(mappedStatusIds);
        }
        List<String> doneStatusIds = mappedStatusIds.getValue().getDoneStatusIds();
        reportModel.doneStatuses = this.getStatuses(doneStatusIds);
        reportModel.notDoneStatuses = this.getStatuses(mappedStatusIds.getValue().getNotDoneStatusIds());
        for (RapidIssueEntry issueEntry : issues) {
            Double estimate = this.getStatFieldValue(issueEntry.getEstimateStatistic());
            if (doneStatusIds.contains(issueEntry.statusId)) {
                completedIssuesEstimateSum += estimate.doubleValue();
                reportContent.completedIssues.add(issueEntry);
            } else if (this.isEstimable(issueEntry)) {
                if (this.isEstimated(issueEntry)) {
                    incompletedIssuesEstimateSum += estimate.doubleValue();
                    reportContent.incompleteEstimatedIssues.add(issueEntry);
                } else {
                    reportContent.incompleteUnestimatedIssues.add(issueEntry);
                }
            } else {
                reportContent.incompleteEstimatedIssues.add(issueEntry);
            }
            this.setEpicLabel(epics, issueEntry);
        }
        reportContent.entityData = issuesResult.getEntityData();
        reportContent.allIssuesEstimateSum = new RapidIssueEntry.NumberFieldValue(completedIssuesEstimateSum + incompletedIssuesEstimateSum);
        reportContent.completedIssuesEstimateSum = new RapidIssueEntry.NumberFieldValue(completedIssuesEstimateSum);
        reportContent.incompletedIssuesEstimateSum = new RapidIssueEntry.NumberFieldValue(incompletedIssuesEstimateSum);
        reportModel.contents = reportContent;
        return ServiceOutcomeImpl.ok(reportModel);
    }

    private void setEpicLabel(List<RapidIssueEntry> epics, RapidIssueEntry issueEntry) {
        if (issueEntry.epic != null) {
            for (RapidIssueEntry epic : epics) {
                if (!epic.key.equals(issueEntry.epic)) continue;
                issueEntry.epicLabel = epic.epicLabel;
            }
        }
    }
}

